/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.openid.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.social.UserIdSource;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.security.SocialAuthenticationFilter;
import org.springframework.social.security.SocialAuthenticationServiceLocator;

public class OpenIdSocialAuthenticationFilter
extends SocialAuthenticationFilter {
    private static final List<String> EXPECTED_OPENID_PARAMS = Collections.unmodifiableList(Arrays.asList("openid_identifier", "openid.identity"));

    public OpenIdSocialAuthenticationFilter(AuthenticationManager authManager, UserIdSource userIdSource, UsersConnectionRepository usersConnectionRepository, SocialAuthenticationServiceLocator authServiceLocator) {
        super(authManager, userIdSource, usersConnectionRepository, authServiceLocator);
    }

    protected boolean detectRejection(HttpServletRequest request) {
        if (!super.detectRejection(request)) {
            return false;
        }
        return OpenIdSocialAuthenticationFilter.isOpenIdRequest(request);
    }

    public static boolean isOpenIdRequest(HttpServletRequest request) {
        Set parameterKeys = request.getParameterMap().keySet();
        if (!parameterKeys.isEmpty()) {
            for (String expected : EXPECTED_OPENID_PARAMS) {
                if (!parameterKeys.contains(expected)) continue;
                return false;
            }
        }
        return true;
    }
}

