/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.openid.security;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openid4java.consumer.ConsumerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.openid.OpenID4JavaConsumer;
import org.springframework.security.openid.OpenIDAuthenticationToken;
import org.springframework.security.openid.OpenIDConsumer;
import org.springframework.security.openid.OpenIDConsumerException;
import org.springframework.social.connect.ConnectionData;
import org.springframework.social.openid.api.OpenId;
import org.springframework.social.openid.connect.OpenIdConnectionFactory;
import org.springframework.social.openid.security.IRealmMapper;
import org.springframework.social.security.SocialAuthenticationRedirectException;
import org.springframework.social.security.SocialAuthenticationToken;
import org.springframework.social.security.provider.AbstractSocialAuthenticationService;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class OpenIdAuthenticationService
extends AbstractSocialAuthenticationService<OpenId> {
    private static final Logger log = LoggerFactory.getLogger(OpenIdAuthenticationService.class);
    public static final String DEFAULT_CLAIMED_IDENTITY_FIELD = "openid_identifier";
    private OpenIdConnectionFactory connectionFactory;
    private OpenIDConsumer consumer;
    private String claimedIdentityFieldName = "openid_identifier";
    private IRealmMapper realmMapper = null;
    private Set<String> returnToUrlParameters = Collections.emptySet();

    public OpenIdAuthenticationService() {
    }

    public OpenIdAuthenticationService(OpenIdConnectionFactory connectionFactory) {
        this();
        this.setConnectionFactory(connectionFactory);
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.consumer == null) {
            try {
                this.consumer = new OpenID4JavaConsumer();
            }
            catch (ConsumerException e) {
                throw new IllegalArgumentException("Failed to initialize OpenID", e);
            }
        }
    }

    public void setConnectionFactory(OpenIdConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public OpenIdConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public SocialAuthenticationToken getAuthToken(HttpServletRequest request, HttpServletResponse response) throws SocialAuthenticationRedirectException {
        String identity = request.getParameter("openid.identity");
        if (!StringUtils.hasText((String)identity)) {
            String claimedIdentity = this.obtainUsername(request);
            try {
                String returnToUrl = this.buildReturnToUrl(request);
                String realm = this.lookupRealm(returnToUrl);
                String openIdUrl = this.consumer.beginConsumption(request, claimedIdentity, returnToUrl, realm);
                if (log.isDebugEnabled()) {
                    log.debug("return_to is '" + returnToUrl + "', realm is '" + realm + "'");
                    log.debug("Redirecting to " + openIdUrl);
                }
                throw new SocialAuthenticationRedirectException(openIdUrl);
            }
            catch (OpenIDConsumerException e) {
                log.debug("Failed to consume claimedIdentity: " + claimedIdentity, (Throwable)e);
                throw new AuthenticationServiceException("Unable to process claimed identity '" + claimedIdentity + "'");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Supplied OpenID identity is " + identity);
        }
        try {
            OpenIDAuthenticationToken token = this.consumer.endConsumption(request);
            String verifiedId = (String)token.getPrincipal();
            ConnectionData data = new ConnectionData(this.connectionFactory.getProviderId(), verifiedId, null, null, null, null, null, null, null);
            return new SocialAuthenticationToken(this.connectionFactory.createConnection(data), this.obtainAccountData(token));
        }
        catch (OpenIDConsumerException oice) {
            throw new AuthenticationServiceException("Consumer error", (Throwable)oice);
        }
    }

    protected Map<String, String> obtainAccountData(OpenIDAuthenticationToken token) {
        return Collections.emptyMap();
    }

    protected String lookupRealm(String returnToUrl) {
        String mapping = null;
        IRealmMapper realmMapper = this.getRealmMapper();
        if (realmMapper != null) {
            mapping = realmMapper.getMapping(returnToUrl);
        }
        if (mapping == null) {
            try {
                URL url = new URL(returnToUrl);
                int port = url.getPort();
                StringBuilder realmBuffer = new StringBuilder(returnToUrl.length()).append(url.getProtocol()).append("://").append(url.getHost());
                if (port > 0) {
                    realmBuffer.append(":").append(port);
                }
                realmBuffer.append("/");
                mapping = realmBuffer.toString();
            }
            catch (MalformedURLException e) {
                log.warn("returnToUrl was not a valid URL: [" + returnToUrl + "]", (Throwable)e);
            }
        }
        return mapping;
    }

    protected String buildReturnToUrl(HttpServletRequest request) {
        StringBuffer sb = request.getRequestURL();
        Iterator<String> iterator = this.returnToUrlParameters.iterator();
        boolean isFirst = true;
        while (iterator.hasNext()) {
            String name = iterator.next();
            String value = request.getParameter(name);
            if (value == null) continue;
            if (isFirst) {
                sb.append("?");
                isFirst = false;
            }
            sb.append(name).append("=").append(value);
            if (!iterator.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    protected String obtainUsername(HttpServletRequest req) {
        String claimedIdentity = req.getParameter(this.claimedIdentityFieldName);
        if (!StringUtils.hasText((String)claimedIdentity)) {
            log.error("No claimed identity supplied in authentication request");
            return "";
        }
        return claimedIdentity.trim();
    }

    public void setClaimedIdentityFieldName(String claimedIdentityFieldName) {
        this.claimedIdentityFieldName = claimedIdentityFieldName;
    }

    public void setConsumer(OpenIDConsumer consumer) {
        this.consumer = consumer;
    }

    public IRealmMapper getRealmMapper() {
        return this.realmMapper;
    }

    public void setRealmMapper(IRealmMapper realmMapper) {
        this.realmMapper = realmMapper;
    }

    public void setReturnToUrlParameters(Set<String> returnToUrlParameters) {
        Assert.notNull(returnToUrlParameters, (String)"returnToUrlParameters cannot be null");
        this.returnToUrlParameters = returnToUrlParameters;
    }
}

