/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.wicketutils.utils;

import javax.annotation.Nonnull;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public abstract class PageSpec {
    private final boolean _bookmarkable;

    public static PageSpec get(final Page page) {
        return new PageSpec(false){

            @Override
            protected void setResponsePage(RequestCycle rc) {
                rc.setResponsePage((IRequestablePage)page);
            }
        };
    }

    public static PageSpec get(Class<? extends Page> pageClass) {
        return PageSpec.get(pageClass, null);
    }

    public static PageSpec get(final Class<? extends Page> pageClass, final PageParameters params) {
        return new PageSpec(true){

            @Override
            protected void setResponsePage(RequestCycle rc) {
                rc.setResponsePage(pageClass, params);
            }
        };
    }

    private PageSpec(boolean bookmarkable) {
        this._bookmarkable = bookmarkable;
    }

    public boolean isBookmarkable() {
        return this._bookmarkable;
    }

    public void setAsResponsePage(boolean redirect) {
        RequestCycle rc = RequestCycle.get();
        if (rc == null) {
            throw new WicketRuntimeException("no request cycle available");
        }
        this.setAsResponsePage(rc, redirect);
    }

    public void setAsResponsePage(@Nonnull RequestCycle rc, boolean redirect) {
        if (rc == null) {
            throw new NullPointerException("rc");
        }
        this.setResponsePage(rc);
    }

    protected abstract void setResponsePage(@Nonnull RequestCycle var1);
}

