/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.wicketutils.openid;

import at.molindo.wicketutils.openid.OpenIdSession;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.markup.html.form.SimpleFormComponentLabel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.UrlValidator;

public class OpenIdFormPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public OpenIdFormPanel(String id) {
        super(id);
        this.add(new Component[]{new OpenIdForm("form")});
    }

    public class OpenIdForm
    extends Form<String> {
        private static final long serialVersionUID = 1L;
        private final Model<String> _openIdModel;

        public OpenIdForm(String id) {
            super(id);
            this.setOutputMarkupId(true);
            this.add(new Behavior[]{new AjaxFormSubmitBehavior(this, "submit"){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target) {
                    OpenIdForm.this.onSubmit();
                }

                protected void onError(AjaxRequestTarget target) {
                    OpenIdForm.this.onError();
                    target.add(new Component[]{OpenIdForm.this});
                }
            }});
            this._openIdModel = new Model();
            TextField field = new TextField("openid", (IModel)this._openIdModel);
            field.setRequired(true);
            field.setLabel((IModel)new ResourceModel("openId", "Open ID"));
            field.add((IValidator)new UrlValidator(new String[]{"http", "https"}));
            this.add(new Component[]{new SimpleFormComponentLabel("label", (LabeledWebMarkupContainer)field)});
            this.add(new Component[]{field});
        }

        protected void onError() {
        }

        protected void onSubmit() {
            OpenIdSession.get().redirect((String)((Object)this._openIdModel.getObject()));
        }
    }
}

