/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.wicketutils.utils;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.Session;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.request.handler.BookmarkablePageRequestHandler;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.mock.MockWebRequest;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.protocol.http.servlet.ServletWebResponse;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.http.handler.RedirectRequestHandler;
import org.apache.wicket.request.mapper.parameter.INamedParameters;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WicketUtils {
    private static final Logger log = LoggerFactory.getLogger(WicketUtils.class);

    private WicketUtils() {
    }

    public static Class<? extends IRequestablePage> getBookmarkablePage(RequestCycle cycle) {
        if (cycle == null) {
            return null;
        }
        IRequestHandler handler = cycle.getActiveRequestHandler();
        if (handler instanceof BookmarkablePageRequestHandler) {
            return ((BookmarkablePageRequestHandler)handler).getPageClass();
        }
        return null;
    }

    public static boolean isBookmarkableRequest(URL url) {
        return WicketUtils.getBookmarkableRequestHandler(url) != null;
    }

    public static Class<? extends IRequestablePage> getBookmarkablePage(URL url) {
        BookmarkablePageRequestHandler handler = WicketUtils.getBookmarkableRequestHandler(url);
        return handler == null ? null : handler.getPageClass();
    }

    @Deprecated
    public static BookmarkablePageRequestHandler getBookmarkableRequestTarget(URL url) {
        return WicketUtils.getBookmarkableRequestHandler(url);
    }

    public static BookmarkablePageRequestHandler getBookmarkableRequestHandler(URL url) {
        IRequestHandler handler = WicketUtils.getRequestHandler(url);
        if (handler instanceof BookmarkablePageRequestHandler) {
            return (BookmarkablePageRequestHandler)handler;
        }
        return null;
    }

    @Deprecated
    public static IRequestHandler getRequestTarget(URL url) {
        return WicketUtils.getRequestHandler(url);
    }

    public static IRequestHandler getRequestHandler(URL url) {
        if (url != null) {
            MockWebRequest request = new MockWebRequest(Url.parse((CharSequence)url.toString()));
            return Application.get().getRootRequestMapper().mapRequest((Request)request);
        }
        return null;
    }

    public static AbstractLink getBookmarkableRefererLink(String id, IModel<String> labelModel) {
        String referer = WicketUtils.getReferer();
        if (referer == null) {
            return null;
        }
        try {
            if (WicketUtils.isBookmarkableRequest(new URL(referer))) {
                return new ExternalLink(id, (IModel)new Model((Serializable)((Object)referer)), labelModel);
            }
        }
        catch (MalformedURLException e) {
            log.warn("malformed referer url: " + referer + " (" + e.toString() + ")");
        }
        return null;
    }

    public static String getReferer() {
        return WicketUtils.getHttpServletRequest().getHeader("Referer");
    }

    public static String getRequested() {
        String query;
        HttpServletRequest req = WicketUtils.getHttpServletRequest();
        StringBuilder buf = new StringBuilder();
        buf.append(req.getServletPath());
        String path = req.getPathInfo();
        if (path != null) {
            buf.append(path);
        }
        if ((query = req.getQueryString()) != null) {
            buf.append("?").append(query);
        }
        return buf.toString();
    }

    public static HttpServletRequest getHttpServletRequest() {
        ServletWebRequest wr = WicketUtils.getServletWebRequest();
        return wr == null ? null : wr.getContainerRequest();
    }

    public static HttpServletResponse getHttpServletResponse() {
        ServletWebResponse wr = WicketUtils.getServletWebResponse();
        return wr == null ? null : wr.getContainerResponse();
    }

    public static HttpSession getHttpSession() {
        HttpServletRequest r = WicketUtils.getHttpServletRequest();
        return r == null ? null : r.getSession();
    }

    public static String getRemoteAddr() {
        return WicketUtils.getHttpServletRequest().getRemoteAddr();
    }

    public static String getRequestParameter(String name) {
        return WicketUtils.getHttpServletRequest().getParameter(name);
    }

    public static Request getRequest() {
        RequestCycle rc = RequestCycle.get();
        return rc == null ? null : rc.getRequest();
    }

    public static WebRequest getWebRequest() {
        Request request = WicketUtils.getRequest();
        return request instanceof WebRequest ? (WebRequest)request : null;
    }

    public static ServletWebRequest getServletWebRequest() {
        Request request = WicketUtils.getRequest();
        return request instanceof ServletWebRequest ? (ServletWebRequest)request : null;
    }

    @Deprecated
    public static RequestCycle getWebRequestCycle() {
        return RequestCycle.get();
    }

    public static Response getResponse() {
        RequestCycle rc = RequestCycle.get();
        return rc == null ? null : rc.getResponse();
    }

    public static WebResponse getWebResponse() {
        Response response = WicketUtils.getResponse();
        return response instanceof WebResponse ? (WebResponse)response : null;
    }

    public static ServletWebResponse getServletWebResponse() {
        Response response = WicketUtils.getResponse();
        return response instanceof ServletWebResponse ? (ServletWebResponse)response : null;
    }

    public static boolean isHttps() {
        return "https".equalsIgnoreCase(WicketUtils.getHttpServletRequest().getScheme());
    }

    public static Cookie getCookie(String name) {
        Cookie[] cookies = WicketUtils.getHttpServletRequest().getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie c : cookies) {
            if (!name.equals(c.getName())) continue;
            return c;
        }
        return null;
    }

    public static void deleteCookie(String name) {
        Cookie c = new Cookie(name, "");
        c.setMaxAge(0);
        WicketUtils.getHttpServletResponse().addCookie(c);
    }

    public static String getHeader(String name) {
        HttpServletRequest r = WicketUtils.getHttpServletRequest();
        return r == null ? null : r.getHeader(name);
    }

    public static WebClientInfo getClientInfo() {
        return (WebClientInfo)Session.get().getClientInfo();
    }

    public static String getUserAgent() {
        WebClientInfo info = WicketUtils.getClientInfo();
        return info == null ? null : info.getUserAgent();
    }

    public static boolean isCookiesDisabled() {
        WebClientInfo info = WicketUtils.getClientInfo();
        return info == null || info.getProperties() == null ? false : !info.getProperties().isCookiesEnabled();
    }

    public static String getClientInfoString() {
        WebClientInfo info = WicketUtils.getClientInfo();
        return info == null ? null : info.getUserAgent() + " (" + info.getProperties().getRemoteAddress() + ")";
    }

    public static String getRequestContextPath() {
        HttpServletRequest r = WicketUtils.getHttpServletRequest();
        if (r == null) {
            return null;
        }
        try {
            URL url = new URL(r.getRequestURL().toString());
            StringBuilder buf = new StringBuilder(100);
            buf.append(url.getProtocol()).append("://").append(url.getHost());
            if (url.getPort() != -1) {
                buf.append(":").append(url.getPort());
            }
            return buf.append(r.getContextPath()).toString();
        }
        catch (MalformedURLException e) {
            throw new WicketRuntimeException("client sent an illegal url?", (Throwable)e);
        }
    }

    public static String getHost() {
        HttpServletRequest r = WicketUtils.getHttpServletRequest();
        if (r == null) {
            return null;
        }
        try {
            return new URL(r.getRequestURL().toString()).getHost();
        }
        catch (MalformedURLException e) {
            throw new WicketRuntimeException("client sent an illegal url?", (Throwable)e);
        }
    }

    @Deprecated
    public static String toAbsolutePath(Class<? extends Page> pageClass) {
        return WicketUtils.toUrl(pageClass, null).toString();
    }

    @Deprecated
    public static String toAbsolutePath(Class<? extends Page> pageClass, PageParameters parameters) {
        return WicketUtils.toUrl(pageClass, parameters).toString();
    }

    public static URL toUrl(Class<? extends Page> pageClass) {
        return WicketUtils.toUrl(pageClass, null);
    }

    public static URL toUrl(Class<? extends Page> pageClass, PageParameters params) {
        String requestUrl = WicketUtils.getHttpServletRequest().getRequestURL().toString();
        String url = RequestUtils.toAbsolutePath((String)requestUrl, (String)RequestCycle.get().urlFor(pageClass, params).toString());
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new WicketRuntimeException("failed to create URL from " + url, (Throwable)e);
        }
    }

    public static void performTemporaryRedirect(String targetURL) {
        WicketUtils.performRedirect(targetURL, 302);
    }

    public static void performPermanentRedirect(String targetURL) {
        WicketUtils.performRedirect(targetURL, 301);
    }

    public static void performRedirect(String targetURL, int statusCode) {
        ThreadContext.getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)new RedirectRequestHandler(targetURL, statusCode));
    }

    public static void performRedirect(Class<? extends Page> pageClass, PageParameters parameters, int statusCode) {
        WicketUtils.performRedirect(WicketUtils.toAbsolutePath(pageClass, parameters), statusCode);
    }

    public static boolean isAjax() {
        Request req = WicketUtils.getRequest();
        if (req instanceof ServletWebRequest) {
            return ((ServletWebRequest)req).isAjax();
        }
        return false;
    }

    public static boolean isDeployment() {
        return RuntimeConfigurationType.DEPLOYMENT.equals((Object)Application.get().getConfigurationType());
    }

    public static LinkedHashMap<String, Object> toMap(PageParameters params) {
        int indexed = params.getIndexedCount();
        List named = params.getAllNamed();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>((indexed + named.size()) * 2);
        for (int i = 0; i < indexed; ++i) {
            map.put(Integer.toString(i), params.get(i));
        }
        for (INamedParameters.NamedPair p : named) {
            map.put(p.getKey(), p.getValue());
        }
        return map;
    }
}

