/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.wicketutils.migration;

import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.UrlEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum WicketURLEncoder {
    QUERY_INSTANCE(UrlEncoder.QUERY_INSTANCE),
    PATH_INSTANCE(UrlEncoder.PATH_INSTANCE),
    FULL_PATH_INSTANCE(UrlEncoder.FULL_PATH_INSTANCE);

    private static final Logger log;
    private final UrlEncoder _encoder;

    private WicketURLEncoder(UrlEncoder encoder) {
        if (encoder == null) {
            throw new NullPointerException("encoder");
        }
        this._encoder = encoder;
    }

    public String encode(String s) {
        Application app = null;
        try {
            app = Application.get();
        }
        catch (WicketRuntimeException ignored) {
            log.warn("No current Application found - defaulting encoding to UTF-8");
        }
        return this.encode(s, app == null ? "UTF-8" : app.getRequestCycleSettings().getResponseRequestEncoding());
    }

    public String encode(String string, String enc) {
        return this._encoder.encode(string, enc);
    }

    static {
        log = LoggerFactory.getLogger(WicketURLEncoder.class);
    }
}

