/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.wicketutils.utils;

import at.molindo.utils.data.Pair;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.request.cycle.RequestCycle;

public class RequestCycleCache {
    private RequestCycleCache() {
    }

    public static <K, V> void put(MetaDataKey<Pair<K, V>> metaDataKey, K key, V value) {
        RequestCycleCache.put(RequestCycle.get(), metaDataKey, key, value);
    }

    public static <K, V> void put(RequestCycle cycle, MetaDataKey<Pair<K, V>> metaDataKey, K key, V value) {
        if (metaDataKey == null) {
            throw new NullPointerException("metaDataKey");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        cycle.setMetaData(metaDataKey, (Object)Pair.pair(key, value));
    }

    public static <K, V> V get(MetaDataKey<Pair<K, V>> metaDataKey, K key) {
        return RequestCycleCache.get(RequestCycle.get(), metaDataKey, key);
    }

    public static <K, V> V get(RequestCycle cycle, MetaDataKey<Pair<K, V>> metaDataKey, K key) {
        if (metaDataKey == null) {
            throw new NullPointerException("metaDataKey");
        }
        if (key == null) {
            return null;
        }
        Pair pair = (Pair)RequestCycle.get().getMetaData(metaDataKey);
        return (V)(pair == null || !pair.getKey().equals(key) ? null : pair.getValue());
    }

    public static <K, V> V getOrCreate(MetaDataKey<Pair<K, V>> metaDataKey, K key, Function<K, V> function) {
        return RequestCycleCache.getOrCreate(RequestCycle.get(), metaDataKey, key, function);
    }

    public static <K, V> V getOrCreate(RequestCycle cycle, MetaDataKey<Pair<K, V>> metaDataKey, K key, Function<K, V> function) {
        V value = RequestCycleCache.get(cycle, metaDataKey, key);
        if (value == null) {
            value = function.invoke(key);
            RequestCycleCache.put(cycle, metaDataKey, key, value);
        }
        return value;
    }

    public static <K, V> void remove(MetaDataKey<Pair<K, V>> metaDataKey) {
        if (metaDataKey != null) {
            RequestCycle.get().setMetaData(metaDataKey, null);
        }
    }

    public static interface Function<K, V> {
        public V invoke(K var1);
    }
}

