/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.wicketutils.utils;

import at.molindo.wicketutils.utils.IMockRequestConfigurer;
import java.util.Locale;
import org.apache.wicket.protocol.http.MockHttpServletRequest;

public interface IMockRequestCallback<V>
extends IMockRequestConfigurer {
    public V call();

    public static class MockRequest {
        private final MockHttpServletRequest _servletRequest;

        MockRequest(MockHttpServletRequest servletRequest) {
            if (servletRequest == null) {
                throw new NullPointerException("servletRequest");
            }
            this._servletRequest = servletRequest;
        }

        public final MockHttpServletRequest getServletRequest() {
            return this._servletRequest;
        }

        public MockRequest setLocale(Locale l) {
            String lang = l.getLanguage();
            String country = l.getCountry();
            String accept = country != null ? lang.toLowerCase() + "-" + country.toLowerCase() + "," + lang.toLowerCase() + ";q=0.5" : lang.toLowerCase();
            this.getServletRequest().addHeader("Accept-Language", accept);
            return this;
        }
    }
}

