/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.wicketutils.openid;

import at.molindo.wicketutils.openid.IOpenIdWebSession;
import at.molindo.wicketutils.openid.OpenIdDetails;
import at.molindo.wicketutils.openid.OpenIdReturnPage;
import at.molindo.wicketutils.utils.WicketUtils;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.IClusterable;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.openid4java.association.AssociationException;
import org.openid4java.consumer.ConsumerAssociationStore;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.InMemoryConsumerAssociationStore;
import org.openid4java.consumer.InMemoryNonceVerifier;
import org.openid4java.consumer.NonceVerifier;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.openid4java.message.sreg.SRegRequest;
import org.openid4java.message.sreg.SRegResponse;

public class OpenIdSession
implements IClusterable {
    private static final MetaDataKey<ConsumerManager> CONSUMER_MANAGER_KEY = new MetaDataKey<ConsumerManager>(){
        private static final long serialVersionUID = 1L;
    };
    private static final long serialVersionUID = 1L;
    private DiscoveryInformation discoveryInformation;

    public static OpenIdSession get() {
        return OpenIdSession.getWebSession().getOpenIdSession();
    }

    public static IOpenIdWebSession getWebSession() {
        return (IOpenIdWebSession)Session.get();
    }

    protected String getOpenIdReturnUrl() {
        return WicketUtils.toAbsolutePath(OpenIdReturnPage.class);
    }

    public void processReturn(PageParameters params) {
        ParameterList response = new ParameterList((Map)params);
        try {
            VerificationResult verificationResult = this.getConsumerManager().verify(this.getOpenIdReturnUrl(), response, this.discoveryInformation);
            Identifier verifiedIdentifier = verificationResult.getVerifiedId();
            if (verifiedIdentifier != null) {
                MessageExtension extension;
                AuthSuccess authSuccess = (AuthSuccess)verificationResult.getAuthResponse();
                OpenIdDetails details = new OpenIdDetails();
                details.setOpenId(verifiedIdentifier.getIdentifier());
                if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0")) {
                    MessageExtension ext = authSuccess.getExtension("http://openid.net/srv/ax/1.0");
                    if (ext instanceof FetchResponse) {
                        FetchResponse fetchResp = (FetchResponse)ext;
                        details.setMail(fetchResp.getAttributeValue("email"));
                        String fullname = fetchResp.getAttributeValue("fullname");
                        if (fullname == null) {
                            String firstname = fetchResp.getAttributeValue("firstname");
                            String lastname = fetchResp.getAttributeValue("lastname");
                            fullname = firstname == null ? (lastname == null ? null : lastname) : (lastname != null ? firstname + " " + lastname : firstname);
                        }
                        details.setName(fullname);
                    }
                } else if (authSuccess.hasExtension("http://openid.net/sreg/1.0") && (extension = authSuccess.getExtension("http://openid.net/sreg/1.0")) instanceof SRegResponse) {
                    SRegResponse sRegResponse = (SRegResponse)extension;
                    details.setMail(sRegResponse.getAttributeValue("email"));
                    details.setName(sRegResponse.getAttributeValue("fullname"));
                }
                OpenIdSession.getWebSession().onOpenIdAuthSuccess(details);
            } else {
                OpenIdSession.getWebSession().onOpenIdAuthError();
            }
        }
        catch (MessageException e) {
            throw new WicketRuntimeException("verification failed", (Throwable)e);
        }
        catch (DiscoveryException e) {
            throw new WicketRuntimeException("discovery failed", (Throwable)e);
        }
        catch (AssociationException e) {
            throw new WicketRuntimeException("association failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerManager getConsumerManager() {
        Application app = Session.get().getApplication();
        ConsumerManager consumerManager = (ConsumerManager)app.getMetaData(CONSUMER_MANAGER_KEY);
        if (consumerManager == null) {
            MetaDataKey<ConsumerManager> metaDataKey = CONSUMER_MANAGER_KEY;
            synchronized (metaDataKey) {
                try {
                    consumerManager = (ConsumerManager)app.getMetaData(CONSUMER_MANAGER_KEY);
                    if (consumerManager == null) {
                        consumerManager = new ConsumerManager();
                        consumerManager.setAssociations((ConsumerAssociationStore)new InMemoryConsumerAssociationStore());
                        consumerManager.setNonceVerifier((NonceVerifier)new InMemoryNonceVerifier(10000));
                        app.setMetaData(CONSUMER_MANAGER_KEY, (Object)consumerManager);
                    }
                }
                catch (ConsumerException e) {
                    throw new RuntimeException("failed to create ConsumerManager", e);
                }
            }
        }
        return consumerManager;
    }

    public void redirect(String openId) {
        this.discoveryInformation = this.performDiscovery(openId);
        AuthRequest authRequest = this.createOpenIdAuthRequest();
        RequestCycle.get().setRedirect(false);
        WicketUtils.getResponse().redirect(authRequest.getDestinationUrl(true));
    }

    private AuthRequest createOpenIdAuthRequest() {
        try {
            ConsumerManager consumerManager = OpenIdSession.get().getConsumerManager();
            AuthRequest auth = consumerManager.authenticate(this.discoveryInformation, OpenIdSession.get().getOpenIdReturnUrl());
            if (this.discoveryInformation.getTypes().contains("http://openid.net/srv/ax/1.0")) {
                FetchRequest fetch = FetchRequest.createFetchRequest();
                fetch.addAttribute("email", "http://axschema.org/contact/email", true);
                fetch.addAttribute("fullname", "http://axschema.org/namePerson", false);
                fetch.addAttribute("firstname", "http://axschema.org/namePerson/first", false);
                fetch.addAttribute("lastname", "http://axschema.org/namePerson/last", false);
                auth.addExtension((MessageExtension)fetch);
            } else if (this.discoveryInformation.getTypes().contains("http://openid.net/sreg/1.0")) {
                SRegRequest sregReq = SRegRequest.createFetchRequest();
                sregReq.addAttribute("fullname", true);
                sregReq.addAttribute("email", true);
                auth.addExtension((MessageExtension)sregReq);
            }
            return auth;
        }
        catch (MessageException e) {
            throw new WicketRuntimeException("failed to create OpenID AuthRequest", (Throwable)e);
        }
        catch (ConsumerException e) {
            throw new WicketRuntimeException("failed to create OpenID AuthRequest", (Throwable)e);
        }
    }

    private DiscoveryInformation performDiscovery(String openId) {
        try {
            ConsumerManager consumerManager = this.getConsumerManager();
            List discoveries = consumerManager.discover(openId);
            return consumerManager.associate(discoveries);
        }
        catch (DiscoveryException e) {
            throw new WicketRuntimeException("discovery failed", (Throwable)e);
        }
    }
}

