/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.metric;

import at.molindo.utils.metric.HourlyCounterAdapter;
import at.molindo.utils.metric.HourlyCounterBean;
import at.molindo.utils.metric.ICounter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlJavaTypeAdapter(value=HourlyCounterAdapter.class)
public class HourlyCounter
implements ICounter {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_HOURS = 168;
    private static final int DEFAULT_GRANULARITY = 60;
    private final int[] _array;
    private final int _hours;
    private final int _granularity;
    private int _currentIndex;
    private int _max = 0;
    private int _min = 0;
    private String _title;

    public HourlyCounter() {
        this(168, 60);
    }

    public HourlyCounter(int hours) {
        this(hours, 60);
    }

    public HourlyCounter(int hours, int granularity) {
        this._hours = hours;
        this._granularity = this.checkGranularity(granularity);
        this._array = new int[this._hours * 60 / this._granularity];
        this._currentIndex = this.calcIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HourlyCounter(HourlyCounter hc) {
        HourlyCounter hourlyCounter = hc;
        synchronized (hourlyCounter) {
            this._array = hc._array;
            this._currentIndex = hc._currentIndex;
            this._hours = hc._hours;
            this._max = hc._max;
            this._min = hc._min;
            this._granularity = hc._granularity;
        }
    }

    public HourlyCounter(HourlyCounterBean hourlyCounterBean) {
        this._array = hourlyCounterBean.getArray();
        this._currentIndex = hourlyCounterBean.getCurrentIndex();
        this._hours = hourlyCounterBean.getHours();
        this._max = hourlyCounterBean.getMax();
        this._min = hourlyCounterBean.getMin();
        this._granularity = hourlyCounterBean.getGranularity();
    }

    @Override
    public int getCount() {
        this.checkTime();
        return this._array[this.index(this._currentIndex)];
    }

    public int getCount(int offset) {
        offset = Math.abs(offset);
        return this._array[this.index(this._currentIndex - offset)];
    }

    private int index(int index) {
        if (index <= this._currentIndex - this._array.length || index > this._currentIndex) {
            throw new IllegalArgumentException("must be > " + -(this._array.length - 1) + " and <= " + this._currentIndex + " but was " + index);
        }
        return (this._array.length + index) % this._array.length;
    }

    public int getHours() {
        return this._hours;
    }

    @Override
    public void increment() {
        this.increment(1);
    }

    @Override
    public void increment(int count) {
        if (count < 1) {
            return;
        }
        this.checkTime();
        int n = this.index(this._currentIndex);
        this._array[n] = this._array[n] + count;
    }

    private synchronized void checkTime() {
        if (this._currentIndex != this.calcIndex()) {
            int val = this._array[this.index(this._currentIndex)];
            if (val > this._max) {
                this._max = val;
            }
            if (this._min == 0 || val < this._min) {
                this._min = val;
            }
            this.incrementIndex();
        }
    }

    private void incrementIndex() {
        int newIndex = this.calcIndex();
        if (newIndex > this._currentIndex) {
            do {
                this._array[this.index((int)(++this._currentIndex))] = 0;
            } while (newIndex > this._currentIndex);
        }
    }

    private int calcIndex() {
        return (int)(System.currentTimeMillis() / ((long)this._granularity * 60000L));
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public int getMax() {
        return this._max;
    }

    public int getMin() {
        return this._min;
    }

    public int[] getData() {
        int[] data = new int[this._array.length];
        for (int i = 0; i < this._array.length; ++i) {
            data[i] = this.getCount(this._array.length - (i + 1));
        }
        return data;
    }

    public int getGranularity() {
        return this._granularity;
    }

    private int checkGranularity(int granularity) {
        if (60 % granularity != 0) {
            throw new IllegalArgumentException("60 mod granularity must be 0 (i.e. 60, 30, 20, 15, 12, 10, 6, 5, 4, 3, 2, 1)");
        }
        return granularity;
    }

    public HourlyCounterBean toHourlyCounterBean() {
        return new HourlyCounterBean(this._array, this._currentIndex, this._granularity, this._hours, this._max, this._min);
    }
}

