/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.collections;

import at.molindo.utils.data.Pair;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class CounterMap<T>
implements Iterable<Pair<T, Integer>> {
    public static final int UNKNOWN = -1;
    private final Map<T, Counter> _counters = new LinkedHashMap<T, Counter>();

    public CounterMap() {
    }

    public CounterMap(Collection<T> objects) {
    }

    public CounterMap(Collection<T> objects, int start) {
        for (T o : objects) {
            this._counters.put(o, new Counter(start));
        }
    }

    public int getCount(T obj) {
        Counter inc = this._counters.get(obj);
        return inc != null ? inc.get() : -1;
    }

    public Pair<T, Integer> get(T obj) {
        return new Pair<T, Integer>(obj, this.getCount(obj));
    }

    public int increment(T obj) {
        Counter c = this._counters.get(obj);
        if (c == null) {
            this._counters.put(obj, new Counter(1));
            return 1;
        }
        return c.increment();
    }

    public boolean contains(T obj) {
        return this._counters.get(obj) != null;
    }

    public boolean add(T obj, int start) {
        if (!this._counters.containsKey(obj)) {
            this._counters.put(obj, new Counter(start));
            return true;
        }
        return false;
    }

    public int remove(T obj) {
        Counter inc = this._counters.remove(obj);
        return inc == null ? -1 : inc.get();
    }

    public int size() {
        return this._counters.size();
    }

    public String toString() {
        return "[CounterMap: " + this._counters + "]";
    }

    @Override
    public Iterator<Pair<T, Integer>> iterator() {
        return new Iterator<Pair<T, Integer>>(){
            private final Iterator<Map.Entry<T, Counter>> _iter;
            {
                this._iter = CounterMap.this._counters.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this._iter.hasNext();
            }

            @Override
            public Pair<T, Integer> next() {
                Map.Entry e = this._iter.next();
                return new Pair(e.getKey(), e.getValue().get());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Pair<T, Integer> getMax() {
        if (this._counters.isEmpty()) {
            return Pair.pair(null, -1);
        }
        Iterator<Pair<T, Integer>> iter = this.iterator();
        Pair<T, Integer> max = iter.next();
        while (iter.hasNext()) {
            Pair<T, Integer> current = iter.next();
            if (current.getValue() <= max.getValue()) continue;
            max = current;
        }
        return max;
    }

    private static class Counter {
        private int _val;

        protected Counter(int val) {
            this._val = val;
        }

        protected int increment() {
            return ++this._val;
        }

        protected int get() {
            return this._val;
        }

        public String toString() {
            return Integer.toString(this._val);
        }
    }
}

