/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.collections;

import at.molindo.utils.collections.IteratorUtils;
import at.molindo.utils.data.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <E> Set<E> unmodifiableSet(Iterable<E> e) {
        return Collections.unmodifiableSet(CollectionUtils.set(e));
    }

    public static <E> Set<E> unmodifiableSet(E ... e) {
        return Collections.unmodifiableSet(CollectionUtils.set(e));
    }

    public static <E, T> Set<E> transformUnmodifiableSet(Iterable<T> e, Function<T, E> f) {
        return Collections.unmodifiableSet(CollectionUtils.transformSet(e, f));
    }

    public static <E> HashSet<E> set(E ... e) {
        return CollectionUtils.set(Arrays.asList(e));
    }

    public static <E> HashSet<E> set(Iterable<E> e) {
        return IteratorUtils.addAll(new HashSet(), IteratorUtils.iterator(e));
    }

    public static <E, T> HashSet<E> transformSet(Iterable<T> e, Function<T, E> f) {
        return IteratorUtils.addAll(new HashSet(), IteratorUtils.transform(IteratorUtils.iterator(e), f));
    }

    public static <E> SortedSet<E> unmodifiableSortedSet(E ... e) {
        return Collections.unmodifiableSortedSet(CollectionUtils.sortedSet(e));
    }

    public static <E> SortedSet<E> unmodifiableSortedSet(Iterable<E> e) {
        return Collections.unmodifiableSortedSet(CollectionUtils.sortedSet(e));
    }

    public static <E, T> SortedSet<E> transformUnmodifiableSortedSet(Iterable<T> e, Function<T, E> f) {
        return Collections.unmodifiableSortedSet(CollectionUtils.transformSortedSet(e, f));
    }

    public static <E> TreeSet<E> sortedSet(E ... e) {
        return CollectionUtils.sortedSet(Arrays.asList(e));
    }

    public static <E> TreeSet<E> sortedSet(Iterable<E> e) {
        return IteratorUtils.addAll(new TreeSet(), IteratorUtils.iterator(e));
    }

    public static <E, T> TreeSet<E> transformSortedSet(Iterable<T> e, Function<T, E> f) {
        return IteratorUtils.addAll(new TreeSet(), IteratorUtils.transform(IteratorUtils.iterator(e), f));
    }

    public static <E> List<E> unmodifiableList(E ... e) {
        return Collections.unmodifiableList(CollectionUtils.list(e));
    }

    public static <E> List<E> unmodifiableList(Iterable<E> e) {
        return Collections.unmodifiableList(CollectionUtils.list(e));
    }

    public static <E, T> List<E> transformUnmodifiableList(Iterable<T> e, Function<T, E> f) {
        return Collections.unmodifiableList(CollectionUtils.transformList(e, f));
    }

    public static <E> ArrayList<E> list(E ... e) {
        return new ArrayList<E>(Arrays.asList(e));
    }

    public static <E> ArrayList<E> list(Iterable<E> e) {
        return IteratorUtils.addAll(new ArrayList(), IteratorUtils.iterator(e));
    }

    public static <E, T> ArrayList<E> transformList(Iterable<T> e, Function<T, E> f) {
        return IteratorUtils.addAll(new ArrayList(), IteratorUtils.transform(IteratorUtils.iterator(e), f));
    }

    public static <K, V> HashMap<K, V> mapKeys(Iterable<K> e, Function<K, V> f) {
        return IteratorUtils.putKeys(new HashMap(), IteratorUtils.iterator(e), f);
    }

    public static <K, V> HashMap<K, V> mapValues(Iterable<V> e, Function<V, K> f) {
        return IteratorUtils.putValues(new HashMap(), IteratorUtils.iterator(e), f);
    }

    public static <T> List<T> subList(List<T> list, int first, int count) {
        if (list.size() < first) {
            return new ArrayList(0);
        }
        return list.subList(first, Math.min(first + count, list.size()));
    }

    public static boolean empty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static boolean empty(Map<?, ?> c) {
        return c == null || c.isEmpty();
    }

    public static <T> T first(Iterable<T> c) {
        return c == null ? null : (T)IteratorUtils.next(IteratorUtils.iterator(c));
    }

    public static <K, V> Map.Entry<K, V> first(Map<K, V> c) {
        return c == null ? null : CollectionUtils.first(c.entrySet());
    }

    public static <K> K firstKey(Map<K, ?> c) {
        return c == null ? null : (K)CollectionUtils.first(c.keySet());
    }

    public static <V> V firstValue(Map<?, V> c) {
        return c == null ? null : (V)CollectionUtils.first(c.values());
    }

    public static <K, V> V putIfAbsent(ConcurrentMap<K, V> map, K key, V value) {
        V current = map.putIfAbsent(key, value);
        return current != null ? current : value;
    }

    public static <T, V> T find(Collection<T> c, Function<T, Boolean> f) {
        for (T t : c) {
            if (f.apply(t) != Boolean.TRUE) continue;
            return t;
        }
        return null;
    }

    public static <T, V> List<T> findAll(Collection<T> c, Function<T, Boolean> f) {
        LinkedList<T> list = new LinkedList<T>();
        for (T t : c) {
            if (f.apply(t) != Boolean.TRUE) continue;
            list.add(t);
        }
        return list;
    }

    public static <T, V> T find(Collection<T> c, Function<T, V> f, V match) {
        for (T t : c) {
            if (!match.equals(f.apply(t))) continue;
            return t;
        }
        return null;
    }

    public static <T, V> List<T> findAll(Collection<T> c, Function<T, V> f, V match) {
        LinkedList<T> list = new LinkedList<T>();
        for (T t : c) {
            if (!match.equals(f.apply(t))) continue;
            list.add(t);
        }
        return list;
    }

    public static <C extends Collection<T>, T, F> C add(C to, F o, Function<? super F, T> f) {
        to.add(f.apply(o));
        return to;
    }

    public static <C extends Collection<T>, T, F> C addAll(C to, Collection<? extends F> from, Function<? super F, T> f) {
        for (F o : from) {
            to.add(f.apply(o));
        }
        return to;
    }

    public static <M extends Map<T, F>, T, F> M put(M to, F o, Function<? super F, T> f) {
        to.put(f.apply(o), o);
        return to;
    }

    public static <M extends Map<T, F>, T, F> M putAll(M to, Collection<? extends F> from, Function<? super F, T> f) {
        for (F o : from) {
            to.put(f.apply(o), o);
        }
        return to;
    }

    public static <T> List<T> resize(List<T> list, int size) {
        return CollectionUtils.resize(list, size, null, null);
    }

    public static <T> List<T> resize(List<T> list, int size, T defaultValue) {
        return CollectionUtils.resize(list, size, defaultValue, null);
    }

    public static <T> List<T> resize(List<T> list, int size, T defaultValue, Collection<T> obsolete) {
        int currentSize = list.size();
        while (currentSize > size) {
            T old;
            if ((old = list.remove(--currentSize)) == null || obsolete == null) continue;
            obsolete.add(old);
        }
        while (currentSize++ < size) {
            list.add(defaultValue);
        }
        return list;
    }

    public static <T> List<T> set(List<T> list, int idx, T obj) {
        return CollectionUtils.set(list, idx, obj, null);
    }

    public static <T> List<T> set(List<T> list, int idx, T obj, T defaultValue) {
        int currentSize = list.size();
        while (currentSize++ <= idx) {
            list.add(defaultValue);
        }
        list.set(idx, obj);
        return list;
    }

    public static <T> void remove(Iterable<T> collection, Function<T, Boolean> function) {
        Iterator<T> iter = collection.iterator();
        while (iter.hasNext()) {
            if (!function.apply(iter.next()).booleanValue()) continue;
            iter.remove();
        }
    }
}

