/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.collections;

import at.molindo.utils.collections.IteratorUtils;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayUtils {
    public static boolean equals(byte[] a, byte[] a2, int off, int len) {
        if (off < 0 || len < 0 || len > ArrayUtils.length(a) - off || len > ArrayUtils.length(a2) - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return true;
        }
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        for (int i = off; i < off + len; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean empty(T[] a) {
        return a == null || a.length == 0;
    }

    public static boolean empty(byte[] a) {
        return a == null || a.length == 0;
    }

    public static boolean empty(int[] a) {
        return a == null || a.length == 0;
    }

    public static boolean empty(short[] a) {
        return a == null || a.length == 0;
    }

    public static boolean empty(long[] a) {
        return a == null || a.length == 0;
    }

    public static boolean empty(float[] a) {
        return a == null || a.length == 0;
    }

    public static boolean empty(double[] a) {
        return a == null || a.length == 0;
    }

    public static boolean empty(char[] a) {
        return a == null || a.length == 0;
    }

    public static <T> T first(T[] a) {
        return ArrayUtils.empty(a) ? null : (T)a[0];
    }

    public static byte first(byte[] a) {
        return ArrayUtils.empty(a) ? (byte)0 : a[0];
    }

    public static int first(int[] a) {
        return ArrayUtils.empty(a) ? 0 : a[0];
    }

    public static short first(short[] a) {
        return ArrayUtils.empty(a) ? (short)0 : a[0];
    }

    public static long first(long[] a) {
        return ArrayUtils.empty(a) ? 0L : a[0];
    }

    public static float first(float[] a) {
        return ArrayUtils.empty(a) ? 0.0f : a[0];
    }

    public static double first(double[] a) {
        return ArrayUtils.empty(a) ? 0.0 : a[0];
    }

    public static char first(char[] a) {
        return ArrayUtils.empty(a) ? (char)'\u0000' : a[0];
    }

    public static <T> T last(T[] a) {
        return ArrayUtils.empty(a) ? null : (T)a[a.length - 1];
    }

    public static byte last(byte[] a) {
        return ArrayUtils.empty(a) ? (byte)0 : a[a.length - 1];
    }

    public static int last(int[] a) {
        return ArrayUtils.empty(a) ? 0 : a[a.length - 1];
    }

    public static short last(short[] a) {
        return ArrayUtils.empty(a) ? (short)0 : a[a.length - 1];
    }

    public static long last(long[] a) {
        return ArrayUtils.empty(a) ? 0L : a[a.length - 1];
    }

    public static float last(float[] a) {
        return ArrayUtils.empty(a) ? 0.0f : a[a.length - 1];
    }

    public static double last(double[] a) {
        return ArrayUtils.empty(a) ? 0.0 : a[a.length - 1];
    }

    public static char last(char[] a) {
        return ArrayUtils.empty(a) ? (char)'\u0000' : a[a.length - 1];
    }

    public static <T> int length(T[] a) {
        return a == null ? 0 : a.length;
    }

    public static int length(byte[] a) {
        return a == null ? 0 : a.length;
    }

    public static int length(int[] a) {
        return a == null ? 0 : a.length;
    }

    public static int length(short[] a) {
        return a == null ? 0 : a.length;
    }

    public static int length(long[] a) {
        return a == null ? 0 : a.length;
    }

    public static int length(float[] a) {
        return a == null ? 0 : a.length;
    }

    public static int length(double[] a) {
        return a == null ? 0 : a.length;
    }

    public static int length(char[] a) {
        return a == null ? 0 : a.length;
    }

    public static <T> T get(T[] a, int i) {
        return ArrayUtils.get(a, i, null);
    }

    public static <T> T get(T[] a, int i, T defaultValue) {
        return ArrayUtils.length(a) < i + 1 ? defaultValue : a[i];
    }

    public static byte get(byte[] a, int i) {
        return ArrayUtils.get(a, i, (byte)0);
    }

    public static byte get(byte[] a, int i, byte defaultValue) {
        return ArrayUtils.length(a) < i + 1 ? defaultValue : a[i];
    }

    public static int get(int[] a, int i) {
        return ArrayUtils.get(a, i, 0);
    }

    public static int get(int[] a, int i, int defaultValue) {
        return ArrayUtils.length(a) < i + 1 ? defaultValue : a[i];
    }

    public static short get(short[] a, int i) {
        return ArrayUtils.get(a, i, (short)0);
    }

    public static short get(short[] a, int i, short defaultValue) {
        return ArrayUtils.length(a) < i + 1 ? defaultValue : a[i];
    }

    public static long get(long[] a, int i) {
        return ArrayUtils.get(a, i, 0L);
    }

    public static long get(long[] a, int i, long defaultValue) {
        return ArrayUtils.length(a) < i + 1 ? defaultValue : a[i];
    }

    public static float get(float[] a, int i) {
        return ArrayUtils.get(a, i, 0.0f);
    }

    public static float get(float[] a, int i, float defaultValue) {
        return ArrayUtils.length(a) < i + 1 ? defaultValue : a[i];
    }

    public static double get(double[] a, int i) {
        return ArrayUtils.get(a, i, 0.0);
    }

    public static double get(double[] a, int i, double defaultValue) {
        return ArrayUtils.length(a) < i + 1 ? defaultValue : a[i];
    }

    public static char get(char[] a, int i) {
        return ArrayUtils.get(a, i, '\u0000');
    }

    public static char get(char[] a, int i, char defaultValue) {
        return ArrayUtils.length(a) < i + 1 ? defaultValue : a[i];
    }

    public static <T> Iterable<T> iterable(final T ... a) {
        if (ArrayUtils.empty(a)) {
            return IteratorUtils.emptyIterable();
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return ArrayUtils.iterator(a);
            }
        };
    }

    public static <T> Iterator<T> iterator(final T ... a) {
        if (ArrayUtils.empty(a)) {
            return IteratorUtils.empty();
        }
        return new Iterator<T>(){
            private int _i = 0;

            @Override
            public boolean hasNext() {
                return this._i < a.length;
            }

            @Override
            public T next() {
                try {
                    return a[this._i++];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterable<Object> toIterable(final Object array) {
        if (array == null) {
            return IteratorUtils.emptyIterable();
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("object not of type array, was " + array.getClass().getName());
        }
        if (Array.getLength(array) == 0) {
            return IteratorUtils.emptyIterable();
        }
        return new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){
                    private int _i = 0;
                    private final int _length;
                    {
                        this._length = Array.getLength(array);
                    }

                    @Override
                    public boolean hasNext() {
                        return this._i < this._length;
                    }

                    @Override
                    public Object next() {
                        return Array.get(array, this._i++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <T> T[] append(T[] a, T o) {
        Object[] copy = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length + 1);
        System.arraycopy(a, 0, copy, 0, a.length);
        copy[a.length] = o;
        return copy;
    }
}

