/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.reflect;

import at.molindo.utils.reflect.ClassUtils;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Locale;

public class AssociatedFileLoader {
    private AssociatedFileLoader() {
    }

    public static AssociatedFile load(Class<?> clazz, String fileExtension, Locale locale) {
        return AssociatedFileLoader.load(clazz, null, AssociatedFileLoader.suffix(fileExtension, locale));
    }

    public static AssociatedFile load(Class<?> clazz, Class<?> baseClass, String fileExtension, Locale locale) {
        return AssociatedFileLoader.load(clazz, baseClass, AssociatedFileLoader.suffix(fileExtension, locale));
    }

    public static AssociatedFile load(Class<?> clazz, String suffix) {
        return AssociatedFileLoader.load(clazz, null, suffix);
    }

    public static AssociatedFile load(Class<?> clazz, Class<?> baseClass, String suffix) {
        Class<?> c;
        if (baseClass == null) {
            baseClass = Object.class;
        }
        Iterator<Class<?>> iter = ClassUtils.hierarchy(clazz);
        do {
            String template;
            if (ClassUtils.getClasspathResource(c = iter.next(), template = c.getSimpleName() + suffix) == null) continue;
            return new AssociatedFile(c, template);
        } while (c != baseClass);
        return null;
    }

    private static String suffix(String fileExtension, Locale locale) {
        StringBuilder buf = new StringBuilder();
        if (locale != null) {
            buf.append("_").append(locale.getLanguage());
        }
        if (fileExtension != null) {
            if (!fileExtension.startsWith(".")) {
                buf.append(".");
            }
            buf.append(fileExtension);
        }
        String suffix = buf.toString();
        return suffix;
    }

    public static final class AssociatedFile {
        private final Class<?> _owner;
        private final String _name;

        private AssociatedFile(Class<?> owner, String name) {
            if (owner == null) {
                throw new NullPointerException("owner");
            }
            if (name == null) {
                throw new NullPointerException("name");
            }
            this._owner = owner;
            this._name = name;
        }

        public Class<?> getOwner() {
            return this._owner;
        }

        public String getName() {
            return this._name;
        }

        public String getPath() {
            return ClassUtils.getPackageResourcePath(this._owner, this._name);
        }

        public InputStream open() {
            InputStream in = ClassUtils.getClasspathResourceAsStream(this._owner, this._name);
            if (in == null) {
                throw new IllegalStateException("AssociatedFile not available: " + this.getPath());
            }
            return in;
        }
    }
}

