/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.metric.percentile;

import at.molindo.utils.metric.percentile.IPercentileCounter;
import at.molindo.utils.metric.percentile.Percentile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;

public class PercentileCounter
implements IPercentileCounter {
    private static final long serialVersionUID = 1L;
    private final int[] _limits;
    private final int[] _counts;
    private int _total;
    private String _title;

    public PercentileCounter(int ... limits) {
        this(TimeUnit.MILLISECONDS, limits);
    }

    public PercentileCounter(TimeUnit unit, int ... limits) {
        if (limits.length == 0) {
            throw new IllegalArgumentException("at least 1 limit required");
        }
        this._limits = Arrays.copyOf(limits, limits.length);
        Arrays.sort(this._limits);
        if (unit != TimeUnit.MILLISECONDS) {
            for (int i = 0; i < this._limits.length; ++i) {
                this._limits[i] = (int)unit.toMillis(this._limits[i]);
            }
        }
        this._counts = new int[this._limits.length];
    }

    @Override
    public void increment(long start) {
        long value = System.currentTimeMillis() - start;
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("cannot increment percentile with values > Integer.MAX_VALUE, was " + value + " (start=" + start + ")");
        }
        this.increment((int)value);
    }

    @Override
    public void increment(int millis) {
        int i = this.index(millis);
        if (i < this._limits.length) {
            int n = i;
            this._counts[n] = this._counts[n] + 1;
        }
        ++this._total;
    }

    int index(int millis) {
        int low = 0;
        int high = this._limits.length - 1;
        int mid = -1;
        while (low <= high) {
            mid = (low + high) / 2;
            int res = this._limits[mid] - millis;
            if (res < 0) {
                low = mid + 1;
                continue;
            }
            if (res > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return this._limits[mid] < millis ? mid + 1 : mid;
    }

    @Override
    public int getTotal() {
        return this._total;
    }

    @Override
    public int estimatePercentile(double percentile) {
        if (percentile < 0.0 || percentile > 100.0) {
            throw new IllegalArgumentException("percentile must be between 0.0 and 100.0, was " + percentile);
        }
        for (Percentile p : this) {
            if (!(percentile - p.getPercentage() <= 1.0E-4)) continue;
            return p.getLimit();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this._counts.length; ++i) {
            this._counts[i] = 0;
        }
        this._total = 0;
    }

    public String toString() {
        double remaining;
        StringBuilder buf = new StringBuilder();
        buf.append(PercentileCounter.class.getSimpleName()).append(": ");
        Percentile last = null;
        for (Percentile p : this) {
            if (last == null || p.getSum() != last.getSum()) {
                buf.append(p).append(", ");
            }
            last = p;
        }
        double d = remaining = last == null ? 0.0 : 100.0 - last.getPercentage();
        if (Math.abs(remaining) > 0.001) {
            int count = this._total - last.getSum();
            int limit = this._limits[this._limits.length - 1];
            buf.append(String.format("%d (%.2f%%) > %d ms", count, remaining, limit));
            buf.append(", ");
        }
        buf.append(this._total).append(" total");
        return buf.toString();
    }

    @Override
    public Iterator<Percentile> iterator() {
        return new Iterator<Percentile>(){
            private final int _total;
            private final int[] _counts;
            private int _i;
            private int _sum;
            {
                this._total = PercentileCounter.this._total;
                this._counts = Arrays.copyOf(PercentileCounter.this._counts, PercentileCounter.this._counts.length);
                this._i = 0;
                this._sum = 0;
            }

            @Override
            public boolean hasNext() {
                return this._i < this._counts.length;
            }

            @Override
            public Percentile next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this._sum += this._counts[this._i];
                Percentile p = new Percentile(this._sum, this._total, PercentileCounter.this._limits[this._i]);
                ++this._i;
                return p;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public List<Percentile> toList() {
        ArrayList<Percentile> list = new ArrayList<Percentile>(this._limits.length);
        for (Percentile p : this) {
            list.add(p);
        }
        return list;
    }

    public int[] getLimits() {
        return Arrays.copyOf(this._limits, this._limits.length);
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }
}

