/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.metric.percentile;

import java.io.Serializable;

public class Percentile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int _sum;
    private final int _total;
    private final int _limit;

    public Percentile(int sum, int total, int limit) {
        this._sum = sum;
        this._total = total;
        this._limit = limit;
    }

    public int getSum() {
        return this._sum;
    }

    public int getTotal() {
        return this._total;
    }

    public int getLimit() {
        return this._limit;
    }

    public double getPercentage() {
        return this._total == 0 ? 0.0 : 100.0 / (double)this._total * (double)this._sum;
    }

    public String toString() {
        return String.format("%d (%.2f%%) <= %d ms", this._sum, this.getPercentage(), this._limit);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._limit;
        result = 31 * result + this._sum;
        result = 31 * result + this._total;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Percentile)) {
            return false;
        }
        Percentile other = (Percentile)obj;
        if (this._limit != other._limit) {
            return false;
        }
        if (this._sum != other._sum) {
            return false;
        }
        return this._total == other._total;
    }
}

