/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.metric.percentile;

import at.molindo.utils.metric.percentile.IIntervalPercentileCounter;
import at.molindo.utils.metric.percentile.IPercentileCounter;
import at.molindo.utils.metric.percentile.Percentile;
import at.molindo.utils.metric.percentile.PercentileCounter;
import at.molindo.utils.metric.percentile.UnmodifiablePercentileCounterWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;

public class IntervalPercentileCounter
implements IIntervalPercentileCounter {
    private static final long serialVersionUID = 1L;
    private String _title;
    private final PercentileCounter[] _counters;
    private int _total;
    private final int _start;
    private final int _millis;
    private volatile int _last;

    public IntervalPercentileCounter(int hours, int ... limits) {
        this(TimeUnit.HOURS, hours, limits);
    }

    public IntervalPercentileCounter(TimeUnit invervalUnit, int hours, int ... limits) {
        this(invervalUnit, hours, TimeUnit.MILLISECONDS, limits);
    }

    public IntervalPercentileCounter(TimeUnit invervalUnit, int size, TimeUnit limitsUnit, int ... limits) {
        if (size < 1) {
            throw new IllegalArgumentException("size must be >= 1, was " + size);
        }
        this._counters = new PercentileCounter[size];
        for (int i = 0; i < this._counters.length; ++i) {
            this._counters[i] = new PercentileCounter(limitsUnit, limits);
        }
        this._millis = (int)invervalUnit.toMillis(1L);
        this._start = (int)(this.currentMillis() / (long)this._millis);
    }

    @Override
    public void increment(long start) {
        this.getCurrent(true).increment(start);
        ++this._total;
    }

    @Override
    public void increment(int millis) {
        this.getCurrent(true).increment(millis);
        ++this._total;
    }

    @Override
    public int getTotal() {
        return this._total;
    }

    @Override
    public Iterator<Percentile> iterator() {
        return this.getCurrent(false).iterator();
    }

    @Override
    public List<Percentile> toList() {
        return this.getCurrent(false).toList();
    }

    @Override
    public List<IPercentileCounter> toCountersList() {
        ArrayList<IPercentileCounter> counters = new ArrayList<IPercentileCounter>(this._counters.length);
        Iterator<IPercentileCounter> iter = this.countersIterator();
        while (iter.hasNext()) {
            counters.add(iter.next());
        }
        return counters;
    }

    public Iterator<IPercentileCounter> countersIterator() {
        return new Iterator<IPercentileCounter>(){
            int _i = 0;
            IPercentileCounter[] _counters = new IPercentileCounter[IntervalPercentileCounter.access$000(IntervalPercentileCounter.this).length];
            {
                int last = IntervalPercentileCounter.this._last;
                for (int i = 0; i < this._counters.length; ++i) {
                    int index = (last + 1 + i) % this._counters.length;
                    PercentileCounter counter = IntervalPercentileCounter.this._counters[index];
                    this._counters[i] = new UnmodifiablePercentileCounterWrapper(counter);
                }
            }

            @Override
            public boolean hasNext() {
                return this._i < this._counters.length;
            }

            @Override
            public IPercentileCounter next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this._counters[this._i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove()");
            }
        };
    }

    @Override
    public int estimatePercentile(double percentile) {
        return this.getCurrent(false).estimatePercentile(percentile);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this._counters.length; ++i) {
            this.clear(i);
        }
    }

    private PercentileCounter clear(int i) {
        this._counters[i] = new PercentileCounter(this._counters[i].getLimits());
        return this._counters[i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PercentileCounter getCurrent(boolean advance) {
        if (!advance) {
            return this._counters[this._last];
        }
        int current = (int)(this.currentMillis() / (long)this._millis) - this._start;
        PercentileCounter counter = this._counters[current %= this._counters.length];
        if (current != this._last) {
            IntervalPercentileCounter intervalPercentileCounter = this;
            synchronized (intervalPercentileCounter) {
                if (current != this._last) {
                    int i = (this._last + 1) % this._counters.length;
                    while (i != current) {
                        this.clear(i);
                        i = (i + 1) % this._counters.length;
                    }
                    this._last = current;
                    counter = this.clear(current);
                }
            }
        }
        return counter;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(IntervalPercentileCounter.class.getSimpleName()).append(": current=[");
        buf.append(this.getCurrent(false).toString());
        buf.append("]");
        return buf.toString();
    }

    protected long currentMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public int[] getLimits() {
        return this.getCurrent(false).getLimits();
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }
}

