/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.data;

import at.molindo.utils.io.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SerializationUtils {
    public static int DEFAULT_BUFFER = 4096;

    private SerializationUtils() {
    }

    public static byte[] serialize(Object obj) throws NotSerializableException {
        return SerializationUtils.serialize(obj, DEFAULT_BUFFER);
    }

    public static byte[] serialize(Object obj, int buffer) throws NotSerializableException {
        byte[] byArray;
        ByteArrayOutputStream out = null;
        ObjectOutputStream oOut = null;
        try {
            out = new ByteArrayOutputStream(buffer);
            oOut = new ObjectOutputStream(out);
            oOut.writeObject(obj);
            byArray = out.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("failed to write to ByteArrayOutputStream", e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(out, oOut);
                throw throwable;
            }
        }
        StreamUtils.close(out, oOut);
        return byArray;
    }

    public static Object deserialize(byte[] bytes) throws ClassNotFoundException {
        Object object;
        ByteArrayInputStream in = null;
        ObjectInputStream oIn = null;
        try {
            in = new ByteArrayInputStream(bytes);
            oIn = new ObjectInputStream(in);
            object = oIn.readObject();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("failed to write to ByteArrayOutputStream", e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(in, oIn);
                throw throwable;
            }
        }
        StreamUtils.close(in, oIn);
        return object;
    }

    public static <T> T deserialize(byte[] bytes, Class<T> cls) throws ClassNotFoundException {
        return cls.cast(SerializationUtils.deserialize(bytes));
    }

    public static Object copy(Object obj) throws NotSerializableException {
        return SerializationUtils.copy(obj, Object.class, DEFAULT_BUFFER);
    }

    public static <T> T copy(T obj, Class<T> cls) throws NotSerializableException {
        return SerializationUtils.copy(obj, cls, DEFAULT_BUFFER);
    }

    public static <T> T copy(T obj, Class<T> cls, int buffer) throws NotSerializableException {
        try {
            return SerializationUtils.deserialize(SerializationUtils.serialize(obj, buffer), cls);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("why can't we deserialize a class we just serialized?", e);
        }
    }
}

