/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.data;

import at.molindo.utils.collections.CollectionUtils;
import java.util.Collection;

public class PrimitiveUtils {
    public static short primitive(Short value) {
        return PrimitiveUtils.primitive(value, (short)0);
    }

    public static short primitive(Short value, int nullValue) {
        return PrimitiveUtils.primitive(value, (short)nullValue);
    }

    public static short primitive(Short value, short nullValue) {
        return value == null ? nullValue : value;
    }

    public static int primitive(Integer value) {
        return PrimitiveUtils.primitive(value, 0);
    }

    public static int primitive(Integer value, int nullValue) {
        return value == null ? nullValue : value;
    }

    public static long primitive(Long value) {
        return PrimitiveUtils.primitive(value, 0L);
    }

    public static long primitive(Long value, long nullValue) {
        return value == null ? nullValue : value;
    }

    public static float primitive(Float value) {
        return PrimitiveUtils.primitive(value, 0.0f);
    }

    public static float primitive(Float value, float nullValue) {
        return value == null ? nullValue : value.floatValue();
    }

    public static double primitive(Double value) {
        return PrimitiveUtils.primitive(value, 0.0);
    }

    public static double primitive(Double value, double nullValue) {
        return value == null ? nullValue : value;
    }

    public static boolean primitive(Boolean value) {
        return PrimitiveUtils.primitive(value, false);
    }

    public static boolean primitive(Boolean value, boolean nullValue) {
        return value == null ? nullValue : value;
    }

    public static char primitive(Character value) {
        return PrimitiveUtils.primitive(value, '\u0000');
    }

    public static char primitive(Character value, char nullValue) {
        return value == null ? nullValue : value.charValue();
    }

    public static byte primitive(Byte value) {
        return PrimitiveUtils.primitive(value, (byte)0);
    }

    public static byte primitive(Byte value, int nullValue) {
        return PrimitiveUtils.primitive(value, (byte)nullValue);
    }

    public static byte primitive(Byte value, byte nullValue) {
        return value == null ? nullValue : value;
    }

    public static short[] primitive(Short[] values) {
        return PrimitiveUtils.primitive(values, (short)0);
    }

    public static short[] primitive(Short[] values, int nullValue) {
        return PrimitiveUtils.primitive(values, (short)nullValue);
    }

    public static short[] primitive(Short[] values, short nullValue) {
        short[] a = new short[values.length];
        for (int i = 0; i < values.length; ++i) {
            a[i] = PrimitiveUtils.primitive(values[i], nullValue);
        }
        return a;
    }

    public static short[] primitive(Collection<Short> values, short nullValue) {
        if (CollectionUtils.empty(values)) {
            return new short[0];
        }
        short[] a = new short[values.size()];
        int i = 0;
        for (Short value : values) {
            a[i++] = PrimitiveUtils.primitive(value, nullValue);
        }
        return a;
    }

    public static int[] primitive(Integer[] values) {
        return PrimitiveUtils.primitive(values, 0);
    }

    public static int[] primitive(Integer[] values, int nullValue) {
        int[] a = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            a[i] = PrimitiveUtils.primitive(values[i], nullValue);
        }
        return a;
    }

    public static int[] primitive(Collection<Integer> values, int nullValue) {
        if (CollectionUtils.empty(values)) {
            return new int[0];
        }
        int[] a = new int[values.size()];
        int i = 0;
        for (Integer value : values) {
            a[i++] = PrimitiveUtils.primitive(value, nullValue);
        }
        return a;
    }

    public static long[] primitive(Long[] values) {
        return PrimitiveUtils.primitive(values, 0L);
    }

    public static long[] primitive(Long[] values, long nullValue) {
        long[] a = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            a[i] = PrimitiveUtils.primitive(values[i], nullValue);
        }
        return a;
    }

    public static long[] primitive(Collection<Long> values, long nullValue) {
        if (CollectionUtils.empty(values)) {
            return new long[0];
        }
        long[] a = new long[values.size()];
        int i = 0;
        for (Long value : values) {
            a[i++] = PrimitiveUtils.primitive(value, nullValue);
        }
        return a;
    }

    public static float[] primitive(Float[] values) {
        return PrimitiveUtils.primitive(values, 0.0f);
    }

    public static float[] primitive(Float[] values, float nullValue) {
        float[] a = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            a[i] = PrimitiveUtils.primitive(values[i], nullValue);
        }
        return a;
    }

    public static float[] primitive(Collection<Float> values, float nullValue) {
        if (CollectionUtils.empty(values)) {
            return new float[0];
        }
        float[] a = new float[values.size()];
        int i = 0;
        for (Float value : values) {
            a[i++] = PrimitiveUtils.primitive(value, nullValue);
        }
        return a;
    }

    public static double[] primitive(Double[] values) {
        return PrimitiveUtils.primitive(values, 0.0);
    }

    public static double[] primitive(Double[] values, double nullValue) {
        double[] a = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            a[i] = PrimitiveUtils.primitive(values[i], nullValue);
        }
        return a;
    }

    public static double[] primitive(Collection<Double> values, double nullValue) {
        if (CollectionUtils.empty(values)) {
            return new double[0];
        }
        double[] a = new double[values.size()];
        int i = 0;
        for (Double value : values) {
            a[i++] = PrimitiveUtils.primitive(value, nullValue);
        }
        return a;
    }

    public static boolean[] primitive(Boolean[] values) {
        return PrimitiveUtils.primitive(values, false);
    }

    public static boolean[] primitive(Boolean[] values, boolean nullValue) {
        boolean[] a = new boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            a[i] = PrimitiveUtils.primitive(values[i], nullValue);
        }
        return a;
    }

    public static boolean[] primitive(Collection<Boolean> values, boolean nullValue) {
        if (CollectionUtils.empty(values)) {
            return new boolean[0];
        }
        boolean[] a = new boolean[values.size()];
        int i = 0;
        for (Boolean value : values) {
            a[i++] = PrimitiveUtils.primitive(value, nullValue);
        }
        return a;
    }

    public static char[] primitive(Character[] values) {
        return PrimitiveUtils.primitive(values, '\u0000');
    }

    public static char[] primitive(Character[] values, char nullValue) {
        char[] a = new char[values.length];
        for (int i = 0; i < values.length; ++i) {
            a[i] = PrimitiveUtils.primitive(values[i], nullValue);
        }
        return a;
    }

    public static char[] primitive(Collection<Character> values, char nullValue) {
        if (CollectionUtils.empty(values)) {
            return new char[0];
        }
        char[] a = new char[values.size()];
        int i = 0;
        for (Character value : values) {
            a[i++] = PrimitiveUtils.primitive(value, nullValue);
        }
        return a;
    }

    public static byte[] primitive(Byte[] values) {
        return PrimitiveUtils.primitive(values, (byte)0);
    }

    public static byte[] primitive(Byte[] values, int nullValue) {
        return PrimitiveUtils.primitive(values, (byte)nullValue);
    }

    public static byte[] primitive(Byte[] values, byte nullValue) {
        byte[] a = new byte[values.length];
        for (int i = 0; i < values.length; ++i) {
            a[i] = PrimitiveUtils.primitive(values[i], nullValue);
        }
        return a;
    }

    public static byte[] primitive(Collection<Byte> values, byte nullValue) {
        if (CollectionUtils.empty(values)) {
            return new byte[0];
        }
        byte[] a = new byte[values.size()];
        int i = 0;
        for (Byte value : values) {
            a[i++] = PrimitiveUtils.primitive(value, nullValue);
        }
        return a;
    }

    public static Short[] object(short[] values) {
        Short[] a = new Short[values.length];
        for (int i = 0; i < values.length; ++i) {
            a[i] = values[i];
        }
        return a;
    }

    public static Integer[] object(int[] values) {
        Integer[] a = new Integer[values.length];
        for (int i = 0; i < values.length; ++i) {
            a[i] = values[i];
        }
        return a;
    }

    public static Long[] object(long[] values) {
        Long[] a = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            a[i] = values[i];
        }
        return a;
    }

    public static Float[] object(float[] values) {
        Float[] a = new Float[values.length];
        for (int i = 0; i < values.length; ++i) {
            a[i] = Float.valueOf(values[i]);
        }
        return a;
    }

    public static Double[] object(double[] values) {
        Double[] a = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            a[i] = values[i];
        }
        return a;
    }

    public static Boolean[] object(boolean[] values) {
        Boolean[] a = new Boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            a[i] = values[i];
        }
        return a;
    }

    public static Character[] object(char[] values) {
        Character[] a = new Character[values.length];
        for (int i = 0; i < values.length; ++i) {
            a[i] = Character.valueOf(values[i]);
        }
        return a;
    }

    public static Byte[] object(byte[] values) {
        Byte[] a = new Byte[values.length];
        for (int i = 0; i < values.length; ++i) {
            a[i] = values[i];
        }
        return a;
    }
}

