/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.metric;

import at.molindo.utils.collections.IteratorUtils;
import at.molindo.utils.data.Function;
import at.molindo.utils.data.PrimitiveUtils;
import at.molindo.utils.data.StringUtils;
import at.molindo.utils.metric.HourlyCounter;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class HourlyCounterBean {
    private static final String DELIM = " ";
    private int[] _array;
    private int _currentIndex;
    private int _granularity;
    private int _hours;
    private int _max;
    private int _min;

    private static int[] splitInts(String valueString, String delim) {
        Iterable<Integer> values = IteratorUtils.transform(StringUtils.split(valueString, delim), new Function<String, Integer>(){

            @Override
            public Integer apply(String input) throws NumberFormatException {
                return StringUtils.empty(input) ? 0 : Integer.valueOf(input);
            }
        });
        return PrimitiveUtils.primitive(IteratorUtils.list(values), 0);
    }

    public HourlyCounterBean() {
    }

    public HourlyCounterBean(int[] array, int currentIndex, int granularity, int hours, int max, int min) {
        this.setArray(array);
        this.setCurrentIndex(currentIndex);
        this.setGranularity(granularity);
        this.setHours(hours);
        this.setMax(max);
        this.setMin(min);
    }

    public HourlyCounter toHourlyCounter() {
        return new HourlyCounter(this);
    }

    @XmlTransient
    public int[] getArray() {
        return this._array;
    }

    public String getValues() {
        return this._array == null ? null : StringUtils.join(DELIM, Arrays.asList(PrimitiveUtils.object(this._array)));
    }

    public int getCurrentIndex() {
        return this._currentIndex;
    }

    public int getHours() {
        return this._hours;
    }

    public int getMax() {
        return this._max;
    }

    public int getMin() {
        return this._min;
    }

    public int getGranularity() {
        return this._granularity;
    }

    public void setArray(int[] array) {
        this._array = array;
    }

    public void setValues(String values) {
        this.setArray(values == null ? null : HourlyCounterBean.splitInts(values, DELIM));
    }

    public void setCurrentIndex(int currentIndex) {
        this._currentIndex = currentIndex;
    }

    public void setHours(int hours) {
        this._hours = hours;
    }

    public void setMax(int max) {
        this._max = max;
    }

    public void setMin(int min) {
        this._min = min;
    }

    public void setGranularity(int granularity) {
        this._granularity = granularity;
    }
}

