/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.io;

import at.molindo.utils.io.Compression;
import at.molindo.utils.io.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class DirectoryUtils {
    private DirectoryUtils() {
    }

    public static Map<File, InputStream> open(File directory, boolean recursive) throws FileNotFoundException, IOException {
        return DirectoryUtils.open(directory, Compression.NONE, recursive);
    }

    public static Map<File, InputStream> open(File directory, Compression compression, boolean recursive) throws FileNotFoundException, IOException {
        HashMap<File, InputStream> map = new HashMap<File, InputStream>();
        if (!directory.isDirectory()) {
            map.put(directory, FileUtils.in(directory, compression));
        } else {
            for (File f : directory.listFiles()) {
                if (!f.isDirectory()) {
                    map.put(f, FileUtils.in(f, compression));
                    continue;
                }
                if (!recursive) continue;
                DirectoryUtils.open(f, compression, true);
            }
        }
        return map;
    }
}

