/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.io;

import java.io.IOException;
import java.io.InputStream;

public class CompositeInputStream
extends InputStream {
    private final InputStream[] _streams;
    private int _current;

    public CompositeInputStream(InputStream ... streams) {
        if (streams == null) {
            throw new NullPointerException("streams");
        }
        if (streams.length == 0) {
            throw new IllegalArgumentException("at least one stream required");
        }
        this._streams = streams;
        this._current = 0;
    }

    @Override
    public int read() throws IOException {
        int result = this._streams[this._current].read();
        if (result == -1 && this._current < this._streams.length - 1) {
            result = this._streams[++this._current].read();
        }
        return result;
    }
}

