/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.data;

import at.molindo.utils.collections.CollectionBuilder;
import at.molindo.utils.data.PairList;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Pair<A, B>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private A _first;
    private B _second;

    public static <K, V> HashMap<K, V> toHashMap(List<Pair<K, V>> pairs) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Pair<K, V> pair : pairs) {
            map.put(pair.getKey(), pair.getValue());
        }
        return map;
    }

    public static Object[] keys(PairList<?, ?> c) {
        return Pair.keys(Object.class, c);
    }

    public static <T> T[] keys(Class<T> cls, PairList<? extends T, ?> c) {
        Object[] a = (Object[])Array.newInstance(cls, c.size());
        int i = 0;
        for (Pair pair : c) {
            a[i++] = pair.getKey();
        }
        return a;
    }

    public static Object[] values(PairList<?, ?> c) {
        return Pair.values(Object.class, c);
    }

    public static <T> T[] values(Class<T> cls, PairList<?, ? extends T> c) {
        Object[] a = (Object[])Array.newInstance(cls, c.size());
        int i = 0;
        for (Pair pair : c) {
            a[i++] = pair.getValue();
        }
        return a;
    }

    public static <K, V> Pair<K, V> pair(K key, V val) {
        return new Pair<K, V>(key, val);
    }

    public static <K, V> Pair<K, V> pair() {
        return new Pair();
    }

    public static <K> PairCollectionBuilder<K, K> pairs(Class<K> kv) {
        return Pair.pairs(kv, kv);
    }

    public static <K, V> PairCollectionBuilder<K, V> pairs(K k, V v) {
        PairCollectionBuilder<K, V> pairs = Pair.pairs();
        pairs.pair(k, v);
        return pairs;
    }

    public static <K, V> PairCollectionBuilder<K, V> pairs(Class<K> k, Class<V> v) {
        return Pair.pairs();
    }

    public static <K, V> PairCollectionBuilder<K, V> pairs() {
        return new PairCollectionBuilder();
    }

    public Pair() {
        this._first = null;
        this._second = null;
    }

    public Pair(A a, B b) {
        this._first = a;
        this._second = b;
    }

    public Pair(Pair<A, B> p) {
        this._first = p.getFirst();
        this._second = p.getSecond();
    }

    public Pair(Map.Entry<A, B> e) {
        this._first = e.getKey();
        this._second = e.getValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._first == null ? 0 : this._first.hashCode());
        result = 31 * result + (this._second == null ? 0 : this._second.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)obj;
        if (this._first == null ? other._first != null : !this._first.equals(other._first)) {
            return false;
        }
        return !(this._second == null ? other._second != null : !this._second.equals(other._second));
    }

    public A getFirst() {
        return this._first;
    }

    public void setFirst(A first) {
        this._first = first;
    }

    public B getSecond() {
        return this._second;
    }

    public void setSecond(B second) {
        this._second = second;
    }

    public B getValue() {
        return this.getSecond();
    }

    public A getKey() {
        return this.getFirst();
    }

    public String toString() {
        return "['" + this.getKey() + "' = '" + this.getValue() + "']";
    }

    public static class PairCollectionBuilder<K, V>
    extends CollectionBuilder<Pair<K, V>, List<Pair<K, V>>> {
        protected PairCollectionBuilder() {
            super(new ArrayList());
        }

        public PairCollectionBuilder<K, V> pair(K key, V value) {
            this.add(Pair.pair(key, value));
            return this;
        }
    }
}

