/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.data;

public class NumberUtils {
    private NumberUtils() {
    }

    public static short checkNull(Short n) {
        return n == null ? (short)0 : n;
    }

    public static int checkNull(Integer n) {
        return n == null ? 0 : n;
    }

    public static long checkNull(Long n) {
        return n == null ? 0L : n;
    }

    public static float checkNull(Float n) {
        return n == null ? 0.0f : n.floatValue();
    }

    public static double checkNull(Double n) {
        return n == null ? 0.0 : n;
    }

    public static short toShort(long n) {
        if (n < -32768L || 32767L < n) {
            throw new IllegalArgumentException("value out of range: " + n);
        }
        return (short)n;
    }

    public static short toShort(int n) {
        if (n < Short.MIN_VALUE || Short.MAX_VALUE < n) {
            throw new IllegalArgumentException("value out of range: " + n);
        }
        return (short)n;
    }

    public static int toInteger(long n) {
        if (n < Integer.MIN_VALUE || Integer.MAX_VALUE < n) {
            throw new IllegalArgumentException("value out of range: " + n);
        }
        return (int)n;
    }

    public static Short toShort(Long n) {
        return n == null ? null : Short.valueOf(NumberUtils.toShort((long)n));
    }

    public static Short toShort(Integer n) {
        return n == null ? null : Short.valueOf(NumberUtils.toShort((int)n));
    }

    public static Integer toInteger(Long n) {
        return n == null ? null : Integer.valueOf(NumberUtils.toInteger((long)n));
    }

    public static Integer toInteger(Short n) {
        return n == null ? null : Integer.valueOf(n.intValue());
    }

    public static Long toLong(Short n) {
        return n == null ? null : Long.valueOf(n.longValue());
    }

    public static Long toLong(Integer n) {
        return n == null ? null : Long.valueOf(n.longValue());
    }
}

