/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.data;

import at.molindo.utils.data.ConversionUtils;
import at.molindo.utils.data.StringUtils;

public abstract class HexUtils {
    private HexUtils() {
    }

    public static String string(byte[] bytes) {
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                buf.append("0");
            }
            buf.append(hex);
        }
        return buf.toString();
    }

    public static String string(int ... bytes) {
        return HexUtils.string(ConversionUtils.bytes(bytes));
    }

    public static byte[] bytes(String hex) {
        byte[] bytes = new byte[hex.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(hex.substring(i * 2, i * 2 + 2), 16);
        }
        return bytes;
    }

    public static String pad(String hex, int bytes) {
        return StringUtils.padLeft(hex, "0", bytes * 2);
    }
}

