/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.collections;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class MapBuilder<K, V, M extends Map<K, V>> {
    private final M _map;

    public static <K, V> MapBuilder<K, V, HashMap<K, V>> map() {
        return new MapBuilder(new HashMap());
    }

    public static <K, V> MapBuilder<K, V, HashMap<K, V>> map(Class<K> keyClass, Class<V> valueClass) {
        return new MapBuilder(new HashMap());
    }

    public static <K, V> MapBuilder<K, V, TreeMap<K, V>> sortedMap() {
        return new MapBuilder(new TreeMap());
    }

    public static <K, V> MapBuilder<K, V, TreeMap<K, V>> sortedMap(Class<K> keyClass, Class<V> valueClass) {
        return new MapBuilder(new TreeMap());
    }

    public static <K, V, M extends Map<K, V>> MapBuilder<K, V, M> builder(M map) {
        return new MapBuilder<K, V, M>(map);
    }

    protected MapBuilder(M map) {
        if (map == null) {
            throw new NullPointerException("map");
        }
        this._map = map;
    }

    public M get() {
        return this._map;
    }

    public Map<K, V> getUnmodifiable() {
        return Collections.unmodifiableMap(this.get());
    }

    public MapBuilder<K, V, M> put(K key, V value) {
        this._map.put(key, value);
        return this;
    }

    public MapBuilder<K, V, M> putAll(Map<? extends K, ? extends V> map) {
        this._map.putAll(map);
        return this;
    }
}

