/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.reflect;

import at.molindo.utils.reflect.ClassUtils;
import at.molindo.utils.reflect.IProxyStripper;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyUtil {
    private static final Logger log = LoggerFactory.getLogger(ProxyUtil.class);

    private ProxyUtil() {
    }

    public static Class<?> getClassWithoutProxy(Object obj) {
        return ProxyUtil.getClassWithoutProxy(Object.class, obj, null);
    }

    public static Class<?> getClassWithoutProxy(Object obj, ClassLoader cl) {
        return ProxyUtil.getClassWithoutProxy(Object.class, obj, cl);
    }

    public static <T> Class<? extends T> getClassWithoutProxy(Class<T> cls, T obj) {
        return ProxyUtil.getClassWithoutProxy(cls, obj, null);
    }

    public static <T> Class<? extends T> getClassWithoutProxy(Class<T> cls, T obj, ClassLoader cl) {
        if (cls == null) {
            throw new NullPointerException("cls");
        }
        if (obj == null) {
            return null;
        }
        if (cl == null) {
            cl = ClassUtils.getClassLoader();
        }
        if (!cls.isInstance(obj)) {
            throw new IllegalArgumentException("object must be an instance of class " + cls.getName());
        }
        for (IProxyStripper stripper : ServiceLoader.load(IProxyStripper.class, cl)) {
            Class<?> stripped = stripper.stripProxyClass(obj);
            if (stripped == null) continue;
            if (!stripped.isInstance(obj)) {
                log.error("object of type {} isn't an intance of stripped class {}", (Object)obj.getClass().getName(), (Object)stripped.getClass().getName());
                continue;
            }
            if (!cls.isAssignableFrom(stripped)) {
                log.error("class {} isn't assignable from stripped class {}", (Object)cls.getName(), (Object)stripped.getClass().getName());
                continue;
            }
            return stripped;
        }
        return obj.getClass();
    }
}

