/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.properties;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SystemProperty {
    FILE_ENCODING("file.encoding"),
    FILE_ENCODING_PKG("file.encoding.pkg"),
    FILE_SEPARATOR("file.separator"),
    JAVA_AWT_GRAPHICSENV("java.awt.graphicsenv"),
    JAVA_AWT_PRINTERJOB("java.awt.printerjob"),
    JAVA_CLASS_PATH("java.class.path"),
    JAVA_CLASS_VERSION("java.class.version"),
    JAVA_COMPILER("java.compiler"),
    JAVA_ENDORSED_DIRS("java.endorsed.dirs"),
    JAVA_EXT_DIRS("java.ext.dirs"),
    JAVA_HOME("java.home"),
    JAVA_IO_TMPDIR("java.io.tmpdir", Type.READ_WRITE){

        @Override
        public String get() {
            String value = super.get();
            if (value == null) {
                return null;
            }
            if (!value.endsWith(File.separator)) {
                value = value + File.separator;
            }
            try {
                new File(value).mkdirs();
            }
            catch (SecurityException e) {
                log.warn("not allowed to create temporary directory: " + value, (Throwable)e);
            }
            return value;
        }
    }
    ,
    JAVA_LIBRARY_PATH("java.library.path"),
    JAVA_RUNTIME_NAME("java.runtime.name"),
    JAVA_RUNTIME_VERSION("java.runtime.version"),
    JAVA_SPECIFICATION_NAME("java.specification.name"),
    JAVA_SPECIFICATION_VENDOR("java.specification.vendor"),
    JAVA_SPECIFICATION_VERSION("java.specification.version"),
    JAVA_VERSION("java.version"),
    JAVA_VENDOR("java.vendor"),
    JAVA_VENDOR_URL("java.vendor.url"),
    JAVA_VENDOR_URL_BUG("java.vendor.url.bug"),
    JAVA_VM_INFO("java.vm.info"),
    JAVA_VM_NAME("java.vm.name"),
    JAVA_VM_SPECIFICATION_NAME("java.vm.specification.name"),
    JAVA_VM_SPECIFICATION_VENDOR("java.vm.specification.vendor"),
    JAVA_VM_SPECIFICATION_VERSION("java.vm.specification.version"),
    JAVA_VM_VERSION("java.vm.version"),
    JAVA_VM_VENDOR("java.vm.vendor"),
    LINE_SEPARATOR("line.separator"),
    OS_NAME("os.name"),
    OS_ARCH("os.arch"),
    OS_VERSION("os.version"),
    PATH_SEPARATOR("path.separator"),
    SUN_ARCH_DATA_MODEL("sun.arch.data.model"),
    SUN_BOOT_CLASS_PATH("sun.boot.class.path"),
    SUN_BOOT_LIBRARY_PATH("sun.boot.library.path"),
    SUN_CPU_ENDIAN("sun.cpu.endian"),
    SUN_CPU_ISALIST("sun.cpu.isalist"),
    SUN_IO_UNICODE_ENCODING("sun.io.unicode.encoding"),
    SUN_JAVA_LAUNCHER("sun.java.launcher"),
    SUN_JNU_ENCODING("sun.jnu.encoding"),
    SUN_MANAGEMENT_COMPILER("sun.management.compiler"),
    SUN_OS_PATCH_LEVEL("sun.os.patch.level"),
    USER_COUNTRY("user.country"),
    USER_DIR("user.dir"),
    USER_HOME("user.home"),
    USER_LANGUAGE("user.language"),
    USER_NAME("user.name"),
    USER_TIMEZONE("user.timezone"),
    USER_VARIANT("user.variant"),
    SUN_DESKTOP("sun.desktop"),
    USER_ZONEINFO_DIR("user.zoneinfo.dir"),
    AWT_NATIVE_DOUBLE_BUFFERING("awt.nativeDoubleBuffering"),
    AWT_TOOLKIT("awt.toolkit"),
    FTP_NON_PROXY_HOSTS("ftp.nonProxyHosts"),
    GOPHER_PROXY_SET("gopherProxySet"),
    HTTP_NON_PROXY_HOSTS("http.nonProxyHosts"),
    MRJ_VERSION("mrj.version"),
    SOCKS_NON_PROXY_HOSTS("socksNonProxyHosts"),
    GNU_CLASSPATH_HOME("gnu.classpath.home"),
    GNU_CLASSPATH_HOME_URL("gnu.classpath.home.url"),
    GNU_CLASSPATH_VERSION("gnu.classpath.version"),
    GNU_CLASSPATH_VM_SHORTNAME("gnu.classpath.vm.shortname"),
    GNU_CPU_ENDIAN("gnu.cpu.endian"),
    GNU_GCJ_PRECOMPILED_DB_PATH("gnu.gcj.precompiled.db.path"),
    GNU_GCJ_PROGNAME("gnu.gcj.progname"),
    GNU_GCJ_RUNTIME_ENDORSED_DIRS("gnu.gcj.runtime.endorsed.dirs"),
    GNU_GCJ_USER_REALNAME("gnu.gcj.user.realname"),
    GNU_JAVA_UTIL_ZONEINFO_DIR("gnu.java.util.zoneinfo.dir"),
    HTTP_AGENT("http.agent"),
    JAVA_FULLVERSION("java.fullversion"),
    USER_REGION("user.region"),
    COM_IBM_CPU_ENDIAN("com.ibm.cpu.endian"),
    COM_IBM_OTI_CONFIGURATION("com.ibm.oti.configuration"),
    COM_IBM_OTI_JCL_BUILD("com.ibm.oti.jcl.build"),
    COM_IBM_OTI_VM_BOOTSTRAP_LIBRARY_PATH("com.ibm.oti.vm.bootstrap.library.path"),
    COM_IBM_OTI_VM_LIBRARY_VERSION("com.ibm.oti.vm.library.version"),
    COM_IBM_UTIL_EXTRALIBS_PROPERTIES("com.ibm.util.extralibs.properties"),
    COM_IBM_VM_BITMODE("com.ibm.vm.bitmode"),
    IBM_SIGNALHANDLING_RS("ibm.signalhandling.rs"),
    IBM_SIGNALHANDLING_SIGCHAIN("ibm.signalhandling.sigchain"),
    IBM_SIGNALHANDLING_SIGINT("ibm.signalhandling.sigint"),
    IBM_SYSTEM_ENCODING("ibm.system.encoding"),
    INVOKEDVIAJAVA("invokedviajava"),
    JAVA_ASSISTIVE("java.assistive"),
    JAVA_AWT_FONTS("java.awt.fonts"),
    JAVA_JCL_VERSION("java.jcl.version"),
    JAVA_UTIL_PREFS__PREFERENCES_FACTORY("java.util.prefs.PreferencesFactory"),
    JXE_CURRENT_ROMIMAGE_VERSION("jxe.current.romimage.version"),
    JXE_LOWEST_ROMIMAGE_VERSION("jxe.lowest.romimage.version"),
    SUN_JAVA2D_FONTPATH("sun.java2d.fontpath"),
    PROGRAM_NAME("program.name"),
    GROOVY_HOME("groovy.home"),
    GROOVY_STARTER_CONF("groovy.starter.conf"),
    JAVA_AWT_HEADLESS("java.awt.headless", Type.READ_WRITE){

        @Override
        public String getDefault() {
            return "false";
        }
    }
    ,
    SUN_AWT_DISABLE_MIXING("sun.awt.disableMixing", Type.READ_WRITE),
    SUN_AWT_NOERASEBACKGROUND("sun.awt.noerasebackground", Type.READ_WRITE),
    SUN_AWT_XEMBEDSERVER("sun.awt.xembedserver", Type.READ_WRITE),
    OS_FAMILY("os.family"){

        @Override
        public String get() {
            String osName = OS_NAME.get();
            if (osName != null) {
                String os = osName.toLowerCase();
                if (os.contains("windows")) {
                    if (os.contains("95") || os.contains("98") || os.contains("me") || os.contains("ce")) {
                        return "win9x";
                    }
                    return "windows";
                }
                if (os.contains("mac")) {
                    return "mac";
                }
                if (os.contains("os/2")) {
                    return "os/2";
                }
                if (os.contains("os/400")) {
                    return "os/400";
                }
                if (os.contains("os/390") || os.contains("z/os")) {
                    return "z/os";
                }
                if (os.contains("netware")) {
                    return "netware";
                }
                if (os.contains("nonstop_kernel")) {
                    return "tandem";
                }
                if (os.contains("openvms")) {
                    return "openvms";
                }
                String pathSeparator = PATH_SEPARATOR.get();
                if (";".equals(pathSeparator)) {
                    return "dos";
                }
                if (":".equals(pathSeparator) && !os.endsWith("X")) {
                    return "unix";
                }
            }
            return "unknown";
        }

        @Override
        public boolean isDerived() {
            return true;
        }
    }
    ,
    JAVA_VM_SERVER("java.vm.server"){

        @Override
        public String get() {
            String vm = JAVA_VM_NAME.get();
            if (vm == null) {
                return null;
            }
            if (vm.startsWith("Java HotSpot(TM)") && vm.contains("Server")) {
                return Boolean.TRUE.toString();
            }
            return Boolean.FALSE.toString();
        }

        @Override
        public boolean isDerived() {
            return true;
        }
    };

    private static final Logger log;
    private final String _name;
    private final boolean _readOnly;

    private SystemProperty(String name) {
        this(name, Type.READ_ONLY);
    }

    private SystemProperty(String name, Type type) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if ("".equals(name = name.trim())) {
            throw new IllegalArgumentException();
        }
        this._name = name;
        boolean bl = this._readOnly = type == Type.READ_ONLY;
        if (!this.isReadOnly() && this.isDerived()) {
            throw new RuntimeException("derived properties must be read-only: " + (Object)((Object)this));
        }
    }

    public String get() {
        String val = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(SystemProperty.this.getName());
            }
        });
        return val != null ? val : this.getDefault();
    }

    public String get(String def) {
        String val = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(SystemProperty.this.getName());
            }
        });
        return val != null ? val : def;
    }

    public Boolean getBoolean() {
        String val = this.get();
        return val == null ? null : Boolean.valueOf(Boolean.parseBoolean(val));
    }

    public Boolean getBoolean(Boolean def) {
        String val = this.get(def == null ? null : def.toString());
        return val == null ? null : Boolean.valueOf(Boolean.parseBoolean(val));
    }

    public Integer getInteger() throws NumberFormatException {
        String val = this.get();
        return val == null ? null : Integer.valueOf(Integer.parseInt(val));
    }

    public Integer getInteger(Integer def) throws NumberFormatException {
        String val = this.get(def == null ? null : def.toString());
        return val == null ? null : Integer.valueOf(Integer.parseInt(val));
    }

    public Long getLong() throws NumberFormatException {
        String val = this.get();
        return val == null ? null : Long.valueOf(Long.parseLong(val));
    }

    public Long getLong(Long def) throws NumberFormatException {
        String val = this.get(def == null ? null : def.toString());
        return val == null ? null : Long.valueOf(Long.parseLong(val));
    }

    public Float getFloat() throws NumberFormatException {
        String val = this.get();
        return val == null ? null : Float.valueOf(Float.parseFloat(val));
    }

    public Float getFloat(Float def) throws NumberFormatException {
        String val = this.get(def == null ? null : def.toString());
        return val == null ? null : Float.valueOf(Float.parseFloat(val));
    }

    public Double getDouble() throws NumberFormatException {
        String val = this.get();
        return val == null ? null : Double.valueOf(Double.parseDouble(val));
    }

    public Double getDouble(Double def) throws NumberFormatException {
        String val = this.get(def == null ? null : def.toString());
        return val == null ? null : Double.valueOf(Double.parseDouble(val));
    }

    public File getFile() {
        String val = this.get();
        return val == null ? null : new File(val);
    }

    public File getFile(String def) {
        String val = this.get(def == null ? null : def.toString());
        return val == null ? null : new File(val);
    }

    public String set(final String value) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException(this.getName() + " is a read-only property");
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.setProperty(SystemProperty.this.getName(), value);
            }
        });
    }

    public String setBoolean(Boolean value) throws NumberFormatException {
        return this.set(value == null ? null : value.toString());
    }

    public String setInteger(Integer value) throws NumberFormatException {
        return this.set(value == null ? null : value.toString());
    }

    public String setLong(Long value) throws NumberFormatException {
        return this.set(value == null ? null : value.toString());
    }

    public String setDouble(Double value) throws NumberFormatException {
        return this.set(value == null ? null : value.toString());
    }

    public String setFloat(Float value) throws NumberFormatException {
        return this.set(value == null ? null : value.toString());
    }

    public String setFile(File value) throws IOException {
        return this.set(value == null ? null : value.getCanonicalPath());
    }

    public String unset() {
        return this.set(null);
    }

    public String getName() {
        return this._name;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public boolean isDerived() {
        return false;
    }

    public String getDefault() {
        return null;
    }

    public String toString() {
        return this.get();
    }

    public String toDebugString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.name()).append(": ");
        buf.append(this.getName()).append("=");
        buf.append(this.get());
        if (this.isDerived()) {
            buf.append(" (derived)");
        } else if (this.isReadOnly()) {
            buf.append(" (read-only)");
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        TreeMap<Object, Object> props = new TreeMap<Object, Object>();
        TreeSet<SystemProperty> unknown = new TreeSet<SystemProperty>();
        props.putAll(System.getProperties());
        for (SystemProperty p : SystemProperty.values()) {
            System.out.println(p.toDebugString());
            if (!props.containsKey(p.getName())) {
                unknown.add(p);
            } else {
                props.remove(p.getName());
            }
            SystemProperty.checkNaming(p);
        }
        if (unknown.size() > 0) {
            System.out.println("\n\n### UNKNOWN");
            for (SystemProperty systemProperty : unknown) {
                System.out.println(systemProperty.toDebugString());
            }
        }
        if (props.size() > 0) {
            System.out.println("\n\n### MISSING");
            for (Map.Entry entry : props.entrySet()) {
                System.out.println(entry);
            }
            System.out.println("\n\n### PLEASE POST FULL OUTPUT . AT http://j.mp/props0 or http://j.mp/props1");
            for (Map.Entry entry : props.entrySet()) {
                System.out.println(String.format("\t/**\n\t * %s only: known values: %s\n\t */\n\t%s(\"%s\"),", new Object[]{OS_NAME, entry.getValue(), SystemProperty.toEnumName((String)entry.getKey()), entry.getKey()}));
            }
        } else {
            System.out.println("\n\n### NO MISSING PROPERTIES, PLEASE POST FULL OUTPUT AT http://j.mp/props0 or http://j.mp/props1");
        }
    }

    private static void checkNaming(SystemProperty p) {
        String expected = SystemProperty.toEnumName(p.getName());
        if (!p.name().equals(expected)) {
            System.err.println("name missmatch: " + p.toDebugString() + " (expected " + expected + ")");
        }
    }

    public static String toEnumName(String property) {
        StringBuilder buf = new StringBuilder();
        for (char c : property.toCharArray()) {
            if (Character.isUpperCase(c)) {
                buf.append('_').append(c);
                continue;
            }
            if (c == '.') {
                buf.append('_');
                continue;
            }
            buf.append(Character.toUpperCase(c));
        }
        return buf.toString();
    }

    static {
        log = LoggerFactory.getLogger(SystemProperty.class);
    }

    private static enum Type {
        READ_WRITE,
        READ_ONLY;

    }
}

