/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

public class RandomUtils {
    private static final ThreadLocal<Random> RAND = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };

    private RandomUtils() {
    }

    public static Random random() {
        return RAND.get();
    }

    public static <T> T get(List<T> list) {
        if (list.size() == 0) {
            throw new ArrayIndexOutOfBoundsException("empty list");
        }
        return list.get(RandomUtils.random().nextInt(list.size()));
    }

    public static <T> List<T> remove(List<T> list, int amount) {
        if (list.size() == 0 || list.size() < amount) {
            throw new ArrayIndexOutOfBoundsException("list size too small");
        }
        ArrayList<T> l = new ArrayList<T>(amount);
        for (int i = 0; i < amount; ++i) {
            l.add(RandomUtils.remove(list));
        }
        return l;
    }

    public static <T> List<T> get(List<T> list, int amount, boolean uniqueResults) {
        if (list.size() == 0 || list.size() < amount) {
            throw new ArrayIndexOutOfBoundsException("list size too small");
        }
        if (!uniqueResults) {
            ArrayList<T> res = new ArrayList<T>(amount);
            for (int i = 0; i < amount; ++i) {
                res.add(RandomUtils.get(list));
            }
            return res;
        }
        ArrayList<T> uniqueList = new ArrayList<T>(new HashSet<T>(list));
        if (uniqueList.size() < amount) {
            throw new ArrayIndexOutOfBoundsException("list does not contain enough unique objects");
        }
        HashSet<T> set = new HashSet<T>(amount);
        while (set.size() < amount) {
            set.add(RandomUtils.get(uniqueList));
        }
        return new ArrayList(set);
    }

    public static <T> T remove(List<T> list) {
        if (list.size() == 0) {
            throw new ArrayIndexOutOfBoundsException("empty list");
        }
        return list.remove(RandomUtils.random().nextInt(list.size()));
    }
}

