/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.collections;

import at.molindo.utils.data.Function;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ListMap<T, E>
implements Map<T, List<E>> {
    private final Map<T, List<E>> _map = this.newMap();

    public static <T, E> ListMap<T, E> newListMap() {
        return new ListMap<T, E>();
    }

    public static <T, E> ListMap<T, E> build(Iterable<E> c, Function<E, T> f) {
        ListMap<T, E> map = ListMap.newListMap();
        for (E e : c) {
            map.add(f.apply(e), e);
        }
        return map;
    }

    protected Map<T, List<E>> newMap() {
        return new HashMap();
    }

    protected List<E> newList() {
        return new LinkedList();
    }

    protected Map<T, List<E>> getMap() {
        return this._map;
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<T, List<E>>> entrySet() {
        return this._map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this._map.equals(o);
    }

    @Override
    public List<E> get(Object key) {
        return this._map.get(key);
    }

    @Override
    public int hashCode() {
        return this._map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public Set<T> keySet() {
        return this._map.keySet();
    }

    public boolean add(T key, E value) {
        return this.getList(key).add(value);
    }

    public boolean addAll(T key, Collection<E> values) {
        return this.getList(key).addAll(values);
    }

    @Override
    public List<E> put(T key, List<E> value) {
        return this._map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends T, ? extends List<E>> m) {
        this._map.putAll(m);
    }

    @Override
    public List<E> remove(Object key) {
        return this._map.remove(key);
    }

    public boolean removeValue(T key, E value) {
        List<E> list = this._map.get(key);
        return list == null ? false : list.remove(value);
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public Collection<List<E>> values() {
        return this._map.values();
    }

    public String toString() {
        return ListMap.class.getSimpleName() + ": " + this._map;
    }

    public List<E> getList(T key) {
        List<E> list = this._map.get(key);
        if (list == null) {
            list = this.newList();
            this._map.put(key, list);
        }
        return list;
    }
}

