/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.collections;

import at.molindo.utils.data.Function;
import at.molindo.utils.data.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

public class IteratorUtils {
    public static final Iterator<?> EMPTY_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    };
    public static final Iterable<?> EMPTY_ITERABLE = new Iterable<Object>(){

        @Override
        public Iterator<Object> iterator() {
            return IteratorUtils.empty();
        }
    };

    private IteratorUtils() {
    }

    public static <T> Iterable<T> iterable(final Iterator<T> iter) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iter;
            }
        };
    }

    public static <T> Iterator<T> iterator(Iterable<T> iterable) {
        return iterable == null ? EMPTY_ITERATOR : iterable.iterator();
    }

    public static <T> Iterator<Iterator<T>> iterators(Iterator<? extends Iterable<T>> iterables) {
        return IteratorUtils.transform(iterables, new Function<Iterable<T>, Iterator<T>>(){

            @Override
            public Iterator<T> apply(Iterable<T> input) {
                return IteratorUtils.iterator(input);
            }
        });
    }

    public static <T> Iterable<Iterator<T>> iterators(Iterable<? extends Iterable<T>> iterables) {
        return IteratorUtils.transform(iterables, new Function<Iterable<T>, Iterator<T>>(){

            @Override
            public Iterator<T> apply(Iterable<T> input) {
                return IteratorUtils.iterator(input);
            }
        });
    }

    public static <T> T next(Iterator<T> iter) {
        return iter == null || !iter.hasNext() ? null : (T)iter.next();
    }

    public static <T> T first(Iterable<T> iter) {
        return iter == null ? null : (T)IteratorUtils.next(iter.iterator());
    }

    public static <T> ArrayList<T> list(Iterable<T> iter) {
        if (iter instanceof Collection) {
            return IteratorUtils.list(IteratorUtils.iterator(iter), ((Collection)iter).size());
        }
        return IteratorUtils.list(IteratorUtils.iterator(iter));
    }

    public static <T> ArrayList<T> list(Iterable<T> iter, int initialCapacity) {
        return IteratorUtils.list(IteratorUtils.iterator(iter), initialCapacity);
    }

    public static <T> ArrayList<T> list(Iterator<T> iter) {
        return IteratorUtils.addAll(new ArrayList(), iter);
    }

    public static <T> ArrayList<T> list(Iterator<T> iter, int initialCapacity) {
        return IteratorUtils.addAll(new ArrayList(initialCapacity), iter);
    }

    public static <T, C extends Collection<T>> C addAll(C collection, Iterator<T> iter) {
        while (iter.hasNext()) {
            collection.add(iter.next());
        }
        return collection;
    }

    public static <K, V, M extends Map<K, V>> M putKeys(M map, Iterator<K> iter, Function<K, V> func) {
        while (iter.hasNext()) {
            K key = iter.next();
            map.put(key, func.apply(key));
        }
        return map;
    }

    public static <K, V, M extends Map<K, V>> M putValues(M map, Iterator<V> iter, Function<V, K> func) {
        while (iter.hasNext()) {
            V value = iter.next();
            map.put(func.apply(value), value);
        }
        return map;
    }

    public static <T> Iterator<T> empty() {
        return EMPTY_ITERATOR;
    }

    public static <T> Iterator<T> empty(Class<T> cls) {
        return IteratorUtils.empty();
    }

    public static <T> Iterable<T> emptyIterable() {
        return EMPTY_ITERABLE;
    }

    public static <T> Iterable<T> emptyIterable(Class<T> cls) {
        return IteratorUtils.emptyIterable();
    }

    public static <T> Iterator<T> notNull(Iterator<T> iter) {
        if (iter == null) {
            return IteratorUtils.empty();
        }
        return iter;
    }

    public static <T> Iterable<T> notNull(Iterable<T> iter) {
        if (iter == null) {
            return IteratorUtils.emptyIterable();
        }
        return iter;
    }

    public static <T> Iterable<T> cast(Class<T> cls, Object[] list) {
        return IteratorUtils.cast(cls, Arrays.asList(list));
    }

    public static <T> Iterable<T> cast(final Class<T> cls, final Iterable<?> iterable) {
        if (cls == null) {
            throw new NullPointerException("cls");
        }
        if (iterable == null) {
            throw new NullPointerException("iterable");
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private final Iterator<?> _iter;
                    {
                        this._iter = iterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this._iter.hasNext();
                    }

                    @Override
                    public T next() {
                        return cls.cast(this._iter.next());
                    }

                    @Override
                    public void remove() {
                        this._iter.remove();
                    }
                };
            }
        };
    }

    public static <T> Iterator<T> skip(Iterator<T> iter, int skip) {
        while (skip-- > 0 && iter.hasNext()) {
            iter.next();
        }
        return iter;
    }

    public static <T> Iterator<T> max(final Iterator<T> iter, final int max) {
        return new Iterator<T>(){
            int _remaining;
            {
                this._remaining = max;
            }

            @Override
            public boolean hasNext() {
                return this._remaining > 0 && iter.hasNext();
            }

            @Override
            public T next() {
                if (this._remaining <= 0) {
                    throw new NoSuchElementException();
                }
                --this._remaining;
                return iter.next();
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    public static <T> Iterator<T> object(final T o) {
        return new Iterator<T>(){
            private boolean _hasNext;
            {
                this._hasNext = o != null;
            }

            @Override
            public boolean hasNext() {
                return this._hasNext;
            }

            @Override
            public T next() {
                if (!this._hasNext) {
                    throw new NoSuchElementException();
                }
                this._hasNext = false;
                return o;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterable<T> filter(final Iterable<T> iterable, final Function<T, Boolean> filter) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return IteratorUtils.filter(iterable.iterator(), filter);
            }
        };
    }

    public static <T> Iterator<T> filter(final Iterator<T> iter, final Function<T, Boolean> filter) {
        return new Iterator<T>(){
            private T _next = this.findNext();
            private boolean _hasNext;

            private T findNext() {
                while (iter.hasNext()) {
                    Object next = iter.next();
                    if (!Boolean.TRUE.equals(filter.apply(next))) continue;
                    this._hasNext = true;
                    return next;
                }
                this._hasNext = false;
                return null;
            }

            @Override
            public boolean hasNext() {
                return this._hasNext;
            }

            @Override
            public T next() {
                Object next = this._next;
                this._next = this.findNext();
                return next;
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    public static <F, T> Iterator<T> transform(final Iterator<? extends F> iter, final Function<F, T> f) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public T next() {
                return f.apply(iter.next());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    public static <F, T> Iterable<T> transform(final Iterable<? extends F> iterable, final Function<F, T> f) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return IteratorUtils.transform(iterable.iterator(), f);
            }
        };
    }

    public static boolean equals(Iterable<?> iterable1, Iterable<?> iterable2) {
        return IteratorUtils.equals(iterable1.iterator(), iterable2.iterator());
    }

    public static boolean equals(Iterator<?> iter1, Iterator<?> iter2) {
        while (iter1.hasNext() && iter2.hasNext()) {
            if (ObjectUtils.equals(iter1.next(), iter2.next())) continue;
            return false;
        }
        return iter1.hasNext() == iter2.hasNext();
    }

    public static <T> Iterable<T> readOnly(final @Nonnull Iterable<T> iter) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return IteratorUtils.readOnly(iter.iterator());
            }
        };
    }

    public static <T> Iterator<T> readOnly(final @Nonnull Iterator<T> iter) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public T next() {
                return iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("read-only");
            }
        };
    }

    public static <T> Iterator<T> chain(Iterator<? extends T> ... iterators) {
        return IteratorUtils.chain(Arrays.asList(iterators));
    }

    public static <T> Iterator<T> chain(Iterable<Iterator<? extends T>> iterable) {
        return IteratorUtils.chain(IteratorUtils.iterator(iterable));
    }

    public static <T> Iterator<T> chain(final Iterator<Iterator<? extends T>> iter) {
        return new Iterator<T>(){
            private final Iterator<Iterator<? extends T>> _iter;
            private Iterator<? extends T> _current;
            private Iterator<? extends T> _previous;
            {
                this._iter = iter;
                if (this._iter.hasNext()) {
                    this._current = this._iter.next();
                    this._previous = IteratorUtils.empty();
                    this.findNext();
                } else {
                    this._current = IteratorUtils.empty();
                }
            }

            private void findNext() {
                while (!this._current.hasNext() && this._iter.hasNext()) {
                    this._current = this._iter.next();
                }
            }

            @Override
            public boolean hasNext() {
                return this._current.hasNext();
            }

            @Override
            public T next() {
                Object next = this._current.next();
                this._previous = this._current;
                this.findNext();
                return next;
            }

            @Override
            public void remove() {
                this._previous.remove();
            }
        };
    }
}

