/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.collections;

import at.molindo.utils.collections.IteratorChain;
import at.molindo.utils.collections.IteratorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class IterableChain<T>
implements Iterable<T> {
    private final Iterable<? extends Iterable<T>> _iterables;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Builder<T> builder(Class<T> cls) {
        return new Builder();
    }

    public static <T> Builder<T> builder(Iterable<T> iter) {
        return new Builder<Iterable<T>>().add(iter);
    }

    public static <T> Builder<T> builder(T o) {
        return new Builder<T>().add(o);
    }

    public static <T> Builder<T> builder(T ... o) {
        return new Builder<T>().add(o);
    }

    public static <T> IterableChain<T> chainIterables(Iterable<? extends Iterable<T>> iterables) {
        return new IterableChain<T>(iterables);
    }

    public IterableChain(Iterable<? extends Iterable<T>> iterables) {
        this._iterables = IteratorUtils.list(iterables);
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorChain(IteratorUtils.iterators(this._iterables));
    }

    public static class Builder<T>
    implements Iterable<T> {
        private final List<Iterable<T>> _iterables = new ArrayList<Iterable<T>>();

        private Builder() {
        }

        public Builder<T> add(Iterable<T> iter) {
            this._iterables.add(iter);
            return this;
        }

        public Builder<T> add(T o) {
            return this.add((T)Collections.singleton(o));
        }

        public Builder<T> add(T ... o) {
            return this.add((T)Arrays.asList(o));
        }

        public IterableChain<T> build() {
            return new IterableChain<T>(this._iterables);
        }

        @Override
        public Iterator<T> iterator() {
            return this.build().iterator();
        }
    }
}

