/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.tools;

import at.molindo.thirdparty.org.springframework.web.util.UriUtils;
import java.io.UnsupportedEncodingException;

public enum URLCoder {
    SCHEME{

        @Override
        public String encode(String string, String encoding) throws UnsupportedEncodingException {
            return UriUtils.encodeScheme(string, encoding);
        }
    }
    ,
    USER_INFO{

        @Override
        public String encode(String string, String encoding) throws UnsupportedEncodingException {
            return UriUtils.encodeUserInfo(string, encoding);
        }
    }
    ,
    HOST{

        @Override
        public String encode(String string, String encoding) throws UnsupportedEncodingException {
            return UriUtils.encodeHost(string, encoding);
        }
    }
    ,
    PORT{

        @Override
        public String encode(String string, String encoding) throws UnsupportedEncodingException {
            return UriUtils.encodePort(string, encoding);
        }
    }
    ,
    PATH{

        @Override
        public String encode(String string, String encoding) throws UnsupportedEncodingException {
            return UriUtils.encodePath(string, encoding);
        }
    }
    ,
    PATH_SEGMENT{

        @Override
        public String encode(String string, String encoding) throws UnsupportedEncodingException {
            return UriUtils.encodePathSegment(string, encoding);
        }
    }
    ,
    QUERY{

        @Override
        public String encode(String string, String encoding) throws UnsupportedEncodingException {
            return UriUtils.encodeQuery(string, encoding);
        }
    }
    ,
    QUERY_PARAM{

        @Override
        public String encode(String string, String encoding) throws UnsupportedEncodingException {
            return UriUtils.encodeQueryParam(string, encoding);
        }
    }
    ,
    FRAGMENT{

        @Override
        public String encode(String string, String encoding) throws UnsupportedEncodingException {
            return UriUtils.encodeFragment(string, encoding);
        }
    }
    ,
    URI{

        @Override
        public String encode(String string, String encoding) throws UnsupportedEncodingException {
            return UriUtils.encodeUri(string, encoding);
        }
    }
    ,
    HTTP_URL{

        @Override
        public String encode(String string, String encoding) throws UnsupportedEncodingException {
            return UriUtils.encodeHttpUrl(string, encoding);
        }
    };


    public abstract String encode(String var1, String var2) throws UnsupportedEncodingException;

    public final String encode(String string) {
        try {
            return this.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Utf8Unsupported(e);
        }
    }

    public final String decode(String string) {
        try {
            return this.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Utf8Unsupported(e);
        }
    }

    public final String decode(String string, String encoding) throws UnsupportedEncodingException {
        return UriUtils.decode(string, encoding);
    }

    public static final class Utf8Unsupported
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public Utf8Unsupported(UnsupportedEncodingException cause) {
            super("utf-8 unsupported?", cause);
        }
    }
}

