/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.collections;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public class CircularQueue<T>
extends AbstractCollection<T>
implements Queue<T> {
    private static final int EMPTY = -1;
    private final T[] _elements;
    private int _first = -1;
    private int _next = 0;

    public CircularQueue(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity must be >= 1, was" + capacity);
        }
        this._elements = new Object[capacity];
    }

    @Override
    public boolean offer(T e) {
        return this.add(e);
    }

    @Override
    public boolean add(T e) {
        if (this.isFull()) {
            this.onOverflow();
        }
        if (this.isFull()) {
            throw new IllegalStateException("Queue full");
        }
        this._elements[this.getAndIncrementNext()] = e;
        return true;
    }

    protected void onOverflow() {
        this.remove();
    }

    @Override
    public T remove() {
        T e = this.poll();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public T poll() {
        if (this.isEmpty()) {
            return null;
        }
        T e = this._elements[this._first];
        this._elements[this.getAndIncrementFirst()] = null;
        return e;
    }

    @Override
    public T element() {
        T e = this.peek();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public T peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this._elements[this._first];
    }

    private int getAndIncrementFirst() {
        int prev = this._first;
        this._first = (this._first + 1) % this._elements.length;
        if (this._first == this._next) {
            this._first = -1;
        }
        return prev;
    }

    private int getAndIncrementNext() {
        int prev = this._next;
        if (this.isEmpty()) {
            this._first = prev;
        }
        this._next = (this._next + 1) % this._elements.length;
        return prev;
    }

    @Override
    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        if (this.isFull()) {
            return this._elements.length;
        }
        return (this._elements.length + this._next - this._first) % this._elements.length;
    }

    public boolean isFull() {
        return this._first == this._next;
    }

    @Override
    public boolean isEmpty() {
        return this._first == -1;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int _next;
            private final int _end;
            {
                this._next = CircularQueue.this._first;
                this._end = CircularQueue.this._next;
            }

            @Override
            public boolean hasNext() {
                return this._next != -1;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object e = CircularQueue.this._elements[this._next];
                this._next = (this._next + 1) % CircularQueue.this._elements.length;
                if (this._next == this._end) {
                    this._next = -1;
                }
                return e;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void clear() {
        this._first = -1;
        Arrays.fill(this._elements, null);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }
}

