/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.reflect;

import at.molindo.thirdparty.org.springframework.core.GenericTypeResolver;
import at.molindo.utils.collections.ArrayUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;

public class ClassUtils {
    private ClassUtils() {
    }

    public static Class<?> getTypeArgument(Class<?> cls, Class<?> genericCls) {
        return ArrayUtils.first(ClassUtils.getTypeArguments(cls, genericCls));
    }

    public static Class<?>[] getTypeArguments(Class<?> cls, Class<?> genericCls) {
        return GenericTypeResolver.resolveTypeArguments(cls, genericCls);
    }

    public static Class<?> toClass(Class<?> declaringCls, Type type) {
        return GenericTypeResolver.extractClass(declaringCls, type);
    }

    public static boolean isAssignable(Class<?> cls, Set<Class<?>> classes) {
        if (cls == null || classes.isEmpty()) {
            return false;
        }
        for (Class<?> c : classes) {
            if (!c.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableToAll(Class<?> cls, Set<Class<?>> classes) {
        if (cls == null) {
            return false;
        }
        for (Class<?> c : classes) {
            if (c.isAssignableFrom(cls)) continue;
            return false;
        }
        return true;
    }

    public static Class<?> forName(String classname) throws ClassNotFoundException {
        return ClassUtils.forName(classname, false, null, null);
    }

    public static Class<?> forName(String classname, boolean init) throws ClassNotFoundException {
        return ClassUtils.forName(classname, init, null, null);
    }

    public static Class<?> forName(String classname, boolean init, Thread thread) throws ClassNotFoundException {
        return ClassUtils.forName(classname, init, thread, null);
    }

    public static Class<?> forName(String classname, boolean init, Class<?> fallback) throws ClassNotFoundException {
        return ClassUtils.forName(classname, init, null, fallback);
    }

    public static Class<?> forName(String classname, boolean init, Thread thread, Class<?> fallback) throws ClassNotFoundException {
        return Class.forName(classname, init, ClassUtils.getClassLoader(thread, fallback));
    }

    public static ClassLoader getClassLoader() {
        return ClassUtils.getClassLoader(null, null);
    }

    public static ClassLoader getClassLoader(Class<?> fallback) {
        return ClassUtils.getClassLoader(null, fallback);
    }

    public static ClassLoader getClassLoader(Thread thread) {
        return ClassUtils.getClassLoader(thread, null);
    }

    public static ClassLoader getClassLoader(Thread thread, Class<?> fallback) {
        ClassLoader loader;
        if (thread == null) {
            thread = Thread.currentThread();
        }
        if ((loader = thread.getContextClassLoader()) == null) {
            loader = (fallback != null ? fallback : ClassUtils.class).getClassLoader();
        }
        if (loader == null) {
            ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    public static URL getClasspathResource(Class<?> scope, String resource) {
        return ClassUtils.getClassLoader(scope).getResource(ClassUtils.getPackageResourcePath(scope, resource));
    }

    public static InputStream getClasspathResourceAsStream(Class<?> scope, String resource) {
        return ClassUtils.getClassLoader(scope).getResourceAsStream(ClassUtils.getPackageResourcePath(scope, resource));
    }

    public static Enumeration<URL> getClasspathResources(Class<?> scope, String resource) throws IOException {
        return ClassUtils.getClassLoader(scope).getResources(ClassUtils.getPackageResourcePath(scope, resource));
    }

    public static String getPackageResourcePath(Class<?> scope, String resource) {
        return scope.getPackage().getName().replace('.', '/') + '/' + resource;
    }
}

