/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.data;

public class StringSimilarityUtils {
    private static final int GAP_COST = 2;

    private StringSimilarityUtils() {
    }

    public static float similarity(String string1, String string2) {
        return StringSimilarityUtils.similarity(string1, string2, 0.0f);
    }

    public static float similarity(String string1, String string2, float min) {
        if (string1.equals(string2)) {
            return 1.0f;
        }
        int l1 = string1.length();
        int l2 = string2.length();
        int maxValue = Math.max(l1, l2) * 2;
        float maxGap = (1.0f - min) * (float)maxValue;
        if ((float)(Math.abs(l1 - l2) * 2) > maxGap) {
            return 0.0f;
        }
        int needlemanWunch = StringSimilarityUtils.unnormalisedSimilarity(string1, string2, maxGap);
        float normalised = 1.0f - (float)needlemanWunch / (float)maxValue;
        return normalised < min ? 0.0f : normalised;
    }

    public static int unnormalisedSimilarity(String string1, String string2) {
        return StringSimilarityUtils.unnormalisedSimilarity(string1, string2, Float.MAX_VALUE);
    }

    public static int unnormalisedSimilarity(String string1, String string2, float maxGap) {
        int j;
        int i;
        char[] s = string1.toCharArray();
        char[] t = string2.toCharArray();
        int n = s.length;
        int m = t.length;
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            int rowMin = 0;
            for (j = 1; j <= m; ++j) {
                int cost = StringSimilarityUtils.cost(s, i - 1, t, j - 1);
                d[i][j] = StringSimilarityUtils.min3(d[i - 1][j] + 2, d[i][j - 1] + 2, d[i - 1][j - 1] + cost);
                if (d[i][j] >= rowMin) continue;
                rowMin = d[i][j];
            }
            if (!((float)rowMin > maxGap)) continue;
            return rowMin;
        }
        return d[n][m];
    }

    private static int min3(int x, int y, int z) {
        int min = y <= z ? y : z;
        return x <= min ? x : min;
    }

    public static final int cost(char[] str1, int string1Index, char[] str2, int string2Index) {
        if (str1[string1Index] == str2[string2Index]) {
            return 0;
        }
        return 1;
    }
}

