/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.data;

import at.molindo.utils.data.Function;
import at.molindo.utils.data.StringUtils;

public class FunctionUtils {
    private FunctionUtils() {
    }

    public static <T> Function<T, String> toStringFunction() {
        return ToString.INSTANCE;
    }

    public static Function<String, String> trimFunction() {
        return Trim.INSTANCE;
    }

    public static Function<String, Integer> parseIntFunction() {
        return ParseInt.INSTANCE;
    }

    public static <F, T, I> Function<F, T> chain(final Function<F, I> first, final Function<I, T> second) {
        return new Function<F, T>(){

            @Override
            public T apply(F input) {
                return second.apply(first.apply(input));
            }
        };
    }

    public static <F, T> Function<F, T> value(final T value) {
        return new Function<F, T>(){

            @Override
            public T apply(F input) {
                return value;
            }
        };
    }

    public static enum ParseInt implements Function<String, Integer>
    {
        INSTANCE;


        @Override
        public Integer apply(String input) {
            return Integer.parseInt(input);
        }
    }

    public static enum Trim implements Function<String, String>
    {
        INSTANCE;


        @Override
        public String apply(String input) {
            return StringUtils.trim(input);
        }
    }

    public static enum ToString implements Function<Object, String>
    {
        INSTANCE;


        @Override
        public String apply(Object input) {
            return StringUtils.string(input);
        }
    }
}

