/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.data;

import at.molindo.utils.data.Pair;
import at.molindo.utils.data.PairList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ArrayPairList<K, V>
extends ArrayList<Pair<K, V>>
implements PairList<K, V> {
    private static final long serialVersionUID = 1L;

    public static <K, V> ArrayPairList<K, V> create() {
        return new ArrayPairList<K, V>();
    }

    public static <K, V> ArrayPairList<K, V> createWithCapacity(int size) {
        return new ArrayPairList<K, V>(size);
    }

    public static <K, V> ArrayPairList<K, V> create(K[] keys, V[] values) {
        return ArrayPairList.create(Arrays.asList(keys), Arrays.asList(values));
    }

    public static <K, V> ArrayPairList<K, V> create(List<K> keys, List<V> values) {
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException("keys and values must be of same length");
        }
        ArrayPairList<K, V> list = ArrayPairList.createWithCapacity(keys.size());
        Iterator<K> keysIter = keys.iterator();
        Iterator<V> valuesIter = values.iterator();
        while (keysIter.hasNext()) {
            list.put(keysIter.next(), valuesIter.next());
        }
        return list;
    }

    public ArrayPairList(int initialCapacity) {
        super(initialCapacity);
    }

    public ArrayPairList() {
    }

    public ArrayPairList(K[] keys, V[] values) {
        this(Arrays.asList(keys), Arrays.asList(values));
    }

    public ArrayPairList(List<K> keys, List<V> values) {
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException("keys and values must be of same length");
        }
        Iterator<K> keysIter = keys.iterator();
        Iterator<V> valuesIter = values.iterator();
        while (keysIter.hasNext()) {
            this.put(keysIter.next(), valuesIter.next());
        }
    }

    public ArrayPairList(Collection<? extends Pair<K, V>> c) {
        super(c);
    }

    @Override
    public void put(K key, V value) {
        this.add(new Pair<K, V>(key, value));
    }
}

