/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.crypto;

import at.molindo.utils.crypto.IDigest;
import at.molindo.utils.crypto.IDigestAlgorithm;
import at.molindo.utils.data.HexUtils;
import at.molindo.utils.io.CharsetUtils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public enum DigestAlgorithm implements IDigestAlgorithm
{
    MD2,
    MD5,
    SHA,
    SHA_256,
    SHA_384,
    SHA_512;

    private final String _name = this.name().replace('_', '-');

    public String getName() {
        return this._name;
    }

    @Override
    public IDigest newDigest() {
        return new IDigest(){
            private final MessageDigest _md;
            {
                this._md = DigestAlgorithm.this.newMessageDigest();
            }

            @Override
            public IDigest add(byte[] bytes) {
                this._md.update(bytes);
                return this;
            }

            @Override
            public IDigest add(ByteBuffer bytes) {
                this._md.update(bytes);
                return this;
            }

            @Override
            public IDigest add(String string) {
                return this.add(string, CharsetUtils.UTF_8);
            }

            @Override
            public IDigest add(String string, Charset charset) {
                this._md.update(string.getBytes(charset));
                return this;
            }

            @Override
            public byte[] digest() {
                return this._md.digest();
            }

            @Override
            public String digestHex() {
                return HexUtils.string(this.digest());
            }

            @Override
            public IDigest reset() {
                this._md.reset();
                return this;
            }
        };
    }

    private MessageDigest newMessageDigest() {
        try {
            return MessageDigest.getInstance(this.getName());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("no such algorithm: " + this.getName(), e);
        }
    }
}

