/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.crypto;

import at.molindo.utils.crypto.IDigestAlgorithm;
import at.molindo.utils.data.HexUtils;
import at.molindo.utils.io.CharsetUtils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public abstract class CryptoUtils {
    private CryptoUtils() {
    }

    public static byte[] digest(byte[] input, IDigestAlgorithm algorithm) {
        return algorithm.newDigest().add(input).digest();
    }

    public static byte[] digest(ByteBuffer input, IDigestAlgorithm algorithm) {
        return algorithm.newDigest().add(input).digest();
    }

    public static byte[] digest(String input, Charset charset, IDigestAlgorithm algorithm) {
        return CryptoUtils.digest(input.getBytes(charset), algorithm);
    }

    public static byte[] digest(String input, IDigestAlgorithm algorithm) {
        return CryptoUtils.digest(input.getBytes(CharsetUtils.UTF_8), algorithm);
    }

    public static String hexDigest(ByteBuffer input, IDigestAlgorithm algorithm) {
        return HexUtils.string(CryptoUtils.digest(input, algorithm));
    }

    public static String hexDigest(byte[] input, IDigestAlgorithm algorithm) {
        return HexUtils.string(CryptoUtils.digest(input, algorithm));
    }

    public static String hexDigest(String input, Charset charset, IDigestAlgorithm algorithm) {
        return HexUtils.string(CryptoUtils.digest(input, charset, algorithm));
    }

    public static String hexDigest(String input, IDigestAlgorithm algorithm) {
        return HexUtils.string(CryptoUtils.digest(input, algorithm));
    }

    public static boolean validate(ByteBuffer input, byte[] digest, IDigestAlgorithm algorithm) {
        return Arrays.equals(CryptoUtils.digest(input, algorithm), digest);
    }

    public static boolean validate(byte[] input, byte[] digest, IDigestAlgorithm algorithm) {
        return Arrays.equals(CryptoUtils.digest(input, algorithm), digest);
    }

    public static boolean validate(String input, Charset charset, byte[] digest, IDigestAlgorithm algorithm) {
        return Arrays.equals(CryptoUtils.digest(input, charset, algorithm), digest);
    }

    public static boolean validate(String input, byte[] digest, IDigestAlgorithm algorithm) {
        return Arrays.equals(CryptoUtils.digest(input, algorithm), digest);
    }

    public static boolean validate(ByteBuffer input, String digest, IDigestAlgorithm algorithm) {
        return CryptoUtils.validate(input, HexUtils.bytes(digest), algorithm);
    }

    public static boolean validate(byte[] input, String digest, IDigestAlgorithm algorithm) {
        return CryptoUtils.validate(input, HexUtils.bytes(digest), algorithm);
    }

    public static boolean validate(String input, Charset charset, String digest, IDigestAlgorithm algorithm) {
        return CryptoUtils.validate(input, charset, HexUtils.bytes(digest), algorithm);
    }

    public static boolean validate(String input, String digest, IDigestAlgorithm algorithm) {
        return CryptoUtils.validate(input, HexUtils.bytes(digest), algorithm);
    }
}

