/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.concurrent;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.LinkedBlockingDeque;
import javax.annotation.Nonnull;

public abstract class ObjectPool<T> {
    private final LinkedBlockingDeque<T> _stack;

    public static <T> ObjectPool<T> create(Class<T> cls, int capacity) {
        try {
            final Constructor<T> constructor = cls.getConstructor(new Class[0]);
            return new ObjectPool<T>(capacity){

                @Override
                protected T create() {
                    try {
                        return constructor.newInstance(new Object[0]);
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException("failed to create new instance of type " + constructor.getDeclaringClass().getName(), e);
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException("failed to create new instance of type " + constructor.getDeclaringClass().getName(), e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("failed to create new instance of type " + constructor.getDeclaringClass().getName(), e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException("failed to create new instance of type " + constructor.getDeclaringClass().getName(), e);
                    }
                }
            };
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(cls.getName() + " does not have an accessible default constructor", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(cls.getName() + " does not have a default constructor", e);
        }
    }

    public ObjectPool(int capacity) {
        this._stack = new LinkedBlockingDeque(capacity);
    }

    public T get() {
        T o = this._stack.poll();
        return o == null ? this.create() : o;
    }

    public void put(T o) {
        if (o != null && this.reset(o)) {
            this._stack.offerFirst(o);
        }
    }

    @Nonnull
    protected abstract T create();

    protected boolean reset(T object) {
        return true;
    }

    public T refresh(T o) {
        if (o != null && this.reset(o)) {
            return o;
        }
        throw new IllegalStateException("failed to refresh object");
    }
}

