/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public class KeyLock<K, V> {
    private final ConcurrentHashMap<K, Task> _map = new ConcurrentHashMap();
    private boolean _wait;

    public static <K, V> KeyLock<K, V> newKeyLock() {
        return new KeyLock<K, V>();
    }

    public static <K, V> KeyLock<K, V> newKeyLock(boolean wait) {
        return new KeyLock<K, V>(wait);
    }

    public KeyLock() {
        this(true);
    }

    public KeyLock(boolean wait) {
        this._wait = wait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V withLock(K key, Callable<? extends V> callable) throws Exception {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (callable == null) {
            throw new NullPointerException("callable");
        }
        Task t = new Task(callable);
        try {
            Task prev = this._map.putIfAbsent(key, t);
            if (prev != null) {
                if (this._wait) {
                    t = prev;
                } else {
                    t = null;
                    throw new KeyLockedException(key);
                }
            }
            Object v = t.perform();
            return v;
        }
        finally {
            if (t != null) {
                this._map.remove(key);
            }
        }
    }

    protected V replace(V result, Exception ex) throws Exception {
        return null;
    }

    public int activeCount() {
        return this._map.size();
    }

    public List<K> activeKeys() {
        return new ArrayList(this._map.keySet());
    }

    public static final class KeyLockedException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final Object _key;

        private KeyLockedException(Object key) {
            super("key locked by different thread");
            this._key = key;
        }

        public Object getKey() {
            return this._key;
        }
    }

    private final class Task {
        private final Callable<? extends V> _callable;
        private Exception _ex;
        private boolean _done = false;
        private V _result;

        public Task(Callable<? extends V> callable) {
            this._callable = callable;
        }

        public synchronized V perform() throws Exception {
            if (!this._done) {
                try {
                    Object v = this._result = this._callable.call();
                    return v;
                }
                catch (Exception e) {
                    this._ex = e;
                    throw e;
                }
                finally {
                    this._done = true;
                }
            }
            return KeyLock.this.replace(this._result, this._ex);
        }
    }
}

