/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.concurrent;

import at.molindo.utils.data.Function;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureUtils {
    private FutureUtils() {
    }

    public static <F, T> Future<T> wrap(final Future<F> future, final Function<F, T> f) {
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return future.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                return f.apply(future.get());
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return f.apply(future.get(timeout, unit));
            }
        };
    }
}

