/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.concurrent;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoryThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(FactoryThread.class);
    private final IRunnableFactory _factory;
    private volatile boolean _active = true;
    private int _errors;
    private int _maxErrors = Integer.MAX_VALUE;

    public FactoryThread(IRunnableFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this._factory = factory;
    }

    public FactoryThread(IRunnableFactory factory, String name) {
        super(name);
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this._factory = factory;
    }

    public FactoryThread(IRunnableFactory factory, ThreadGroup group, String name) {
        super(group, name);
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this._factory = factory;
    }

    @Override
    public void run() {
        while (this._active) {
            try {
                this._factory.newRunnable().run();
                this._errors = 0;
            }
            catch (Throwable t) {
                ++this._errors;
                if (this._errors >= this._maxErrors) {
                    this.handleException(t, this._errors, true);
                    this.setInactive();
                    continue;
                }
                this.handleException(t, this._errors, false);
            }
        }
    }

    protected void handleException(Throwable t, int consecutiveErrors, boolean terminate) {
        if (terminate) {
            log.error("unhandled exception from created runnable, terminating after " + consecutiveErrors + " consecutive errors", t);
        } else {
            log.warn("unhandled exception from created runnable, " + consecutiveErrors + " consecutive errors, continuing", t);
        }
    }

    public FactoryThread setInactive() {
        this._active = false;
        return this;
    }

    public FactoryThread setMaxErrors(int maxErrors) {
        this._maxErrors = maxErrors;
        return this;
    }

    public static class FactoryThreadGroup
    extends ThreadGroup {
        private final List<FactoryThread> _threads = new ArrayList<FactoryThread>();

        public FactoryThreadGroup(String groupName, @Nonnegative int threads, @Nonnull IRunnableFactory factory) {
            super(groupName);
            for (int i = 0; i < threads; ++i) {
                this._threads.add(new FactoryThread(factory, this, groupName + "#" + i){

                    @Override
                    protected void handleException(Throwable t, int consecutiveErrors, boolean terminate) {
                        FactoryThreadGroup.this.handleException(t, consecutiveErrors, terminate);
                    }
                });
            }
        }

        public FactoryThreadGroup setMaxErrors(int maxErrors) {
            for (FactoryThread t : this._threads) {
                t.setMaxErrors(maxErrors);
            }
            return this;
        }

        public FactoryThreadGroup start() {
            for (FactoryThread t : this._threads) {
                t.start();
            }
            return this;
        }

        public FactoryThreadGroup setInactive() {
            for (FactoryThread t : this._threads) {
                t.setInactive();
            }
            return this;
        }

        public FactoryThreadGroup join() throws InterruptedException {
            for (FactoryThread t : this._threads) {
                t.join();
            }
            return this;
        }

        public FactoryThreadGroup join(long millis) throws InterruptedException {
            long end = System.currentTimeMillis() + millis;
            for (FactoryThread t : this._threads) {
                long remaining = end - System.currentTimeMillis();
                if (remaining <= 0L) continue;
                t.join(remaining);
            }
            return this;
        }

        protected void handleException(Throwable t, int consecutiveErrors, boolean terminate) {
            if (terminate) {
                log.error("unhandled exception from created runnable, terminating after " + consecutiveErrors + " consecutive errors", t);
            } else {
                log.warn("unhandled exception from created runnable, " + consecutiveErrors + " consecutive errors, continuing", t);
            }
        }
    }

    public static interface IRunnableFactory {
        @Nonnull
        public Runnable newRunnable();
    }
}

