/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.collections;

import at.molindo.utils.collections.IteratorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class IteratorChain<T>
implements Iterator<T> {
    private final Iterator<Iterator<T>> _iterators;
    private Iterator<T> _next;
    private Iterator<T> _last;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Builder<T> builder(Class<T> cls) {
        return IteratorChain.builder();
    }

    public static <T> Builder<T> builder(Iterator<T> iter) {
        return new Builder<Iterator<T>>().add(iter);
    }

    public static <T> Builder<T> builder(Iterable<T> iter) {
        return new Builder<Iterable<T>>().add(iter);
    }

    public static <T> Builder<T> builder(T o) {
        return new Builder<T>().add(o);
    }

    public static <T> Builder<T> builder(T ... o) {
        return new Builder<T>().add(o);
    }

    public static <T> IteratorChain<T> chainIterables(Iterable<? extends Iterable<T>> iterables) {
        return new IteratorChain(IteratorUtils.iterators(iterables));
    }

    public static <T> IteratorChain<T> chainIterables(Iterator<? extends Iterable<T>> iterables) {
        return new IteratorChain(IteratorUtils.iterators(iterables));
    }

    public IteratorChain(Iterable<Iterator<T>> iterators) {
        this(iterators.iterator());
    }

    public IteratorChain(Iterator<Iterator<T>> iterator) {
        this._iterators = IteratorUtils.list(iterator).iterator();
        if (this._iterators.hasNext()) {
            this._next = this._iterators.next();
        }
    }

    @Override
    public boolean hasNext() {
        if (this._next == null) {
            return false;
        }
        if (this._next.hasNext()) {
            return true;
        }
        if (this._iterators.hasNext()) {
            this._next = this._iterators.next();
            return this.hasNext();
        }
        this._next = null;
        return false;
    }

    @Override
    public T next() {
        if (this._next == null) {
            throw new NoSuchElementException();
        }
        T o = this._next.next();
        this._last = this._next;
        return o;
    }

    @Override
    public void remove() {
        if (this._last == null) {
            throw new IllegalStateException("next() has not yet been called");
        }
        this._last.remove();
    }

    public static class Builder<T>
    implements Iterable<T> {
        private final List<Iterator<T>> _iterators = new ArrayList<Iterator<T>>();

        private Builder() {
        }

        public Builder<T> add(Iterator<T> iter) {
            this._iterators.add(iter);
            return this;
        }

        public Builder<T> add(Iterable<T> iter) {
            return this.add((T)iter.iterator());
        }

        public Builder<T> add(T o) {
            return this.add((T)Collections.singleton(o).iterator());
        }

        public Builder<T> add(T ... o) {
            return this.add((T)Arrays.asList(o).iterator());
        }

        public IteratorChain<T> build() {
            return new IteratorChain<T>(this._iterators);
        }

        @Override
        public Iterator<T> iterator() {
            return this.build();
        }
    }
}

