/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.collections;

import at.molindo.utils.collections.IBusinessKey;
import at.molindo.utils.collections.IBusinessKeyMap;
import at.molindo.utils.collections.IBusinessKeySet;
import java.util.Collection;
import java.util.Iterator;

class BusinessKeySet<K, V extends IBusinessKey<K>>
implements IBusinessKeySet<K, V> {
    private final IBusinessKeyMap<K, V> _map;

    static <K, V extends IBusinessKey<K>> BusinessKeySet<K, V> newSet(IBusinessKeyMap<K, V> map) {
        return new BusinessKeySet<K, V>(map);
    }

    private BusinessKeySet(IBusinessKeyMap<K, V> map) {
        if (map == null) {
            throw new NullPointerException("map");
        }
        this._map = map;
    }

    @Override
    public IBusinessKeyMap<K, V> getMap() {
        return this._map;
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public Iterator<V> iterator() {
        return this._map.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this._map.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this._map.values().toArray(a);
    }

    @Override
    public boolean add(V e) {
        Object key = e.getBusinessKey();
        IBusinessKey prev = (IBusinessKey)this._map.put(key, e);
        if (prev != null) {
            this._map.put(key, prev);
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        boolean changed = false;
        for (IBusinessKey o : c) {
            changed |= this.add((V)o);
        }
        return changed;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof IBusinessKey) {
            Object key = ((IBusinessKey)o).getBusinessKey();
            Object mapped = this._map.get(key);
            return mapped != null && mapped.equals(o);
        }
        return false;
    }

    @Override
    public boolean containsKey(K key) {
        return this._map.containsKey(key);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAllKeys(Iterable<K> keys) {
        for (K key : keys) {
            if (this.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Object key;
        Object mapped;
        if (o instanceof IBusinessKey && (mapped = this._map.get(key = ((IBusinessKey)o).getBusinessKey())) != null && mapped.equals(o)) {
            return this._map.remove(key) != null;
        }
        return false;
    }

    @Override
    public boolean removeKey(K key) {
        return this._map.remove(key) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed |= this.remove(o);
        }
        return changed;
    }

    @Override
    public boolean removeAllKeys(Iterable<K> keys) {
        boolean changed = false;
        for (K key : keys) {
            changed |= this.removeKey(key);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator<V> iter = this.iterator();
        while (iter.hasNext()) {
            if (c.contains(iter.next())) continue;
            iter.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAllKeys(Collection<K> keys) {
        boolean changed = false;
        Iterator iter = this._map.keySet().iterator();
        while (iter.hasNext()) {
            if (keys.contains(iter.next())) continue;
            iter.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this._map.clear();
    }
}

