/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.collections;

import at.molindo.utils.collections.BusinessKeySet;
import at.molindo.utils.collections.IBusinessKey;
import at.molindo.utils.collections.IBusinessKeyMap;
import at.molindo.utils.collections.IBusinessKeySet;
import java.util.HashMap;
import java.util.Iterator;

public class BusinessKeyHashMap<K, V extends IBusinessKey<K>>
extends HashMap<K, V>
implements IBusinessKeyMap<K, V> {
    private static final long serialVersionUID = 1L;
    private transient IBusinessKeySet<K, V> _valueSet;

    public static <K, V extends IBusinessKey<K>> BusinessKeyHashMap<K, V> newMap(Class<V> cls) {
        return new BusinessKeyHashMap<K, V>();
    }

    public static <K, V extends IBusinessKey<K>> BusinessKeyHashMap<K, V> newMap(Iterable<V> c) {
        BusinessKeyHashMap<K, V> map = BusinessKeyHashMap.newMap();
        map.putAll(c);
        return map;
    }

    public static <K, V extends IBusinessKey<K>> BusinessKeyHashMap<K, V> newMap() {
        return new BusinessKeyHashMap<K, V>();
    }

    @Override
    public V put(V v) {
        return (V)((IBusinessKey)this.put(v.getBusinessKey(), v));
    }

    @Override
    public void putAll(Iterable<V> c) {
        for (IBusinessKey v : c) {
            this.put(v);
        }
    }

    @Override
    public IBusinessKeySet<K, V> valueSet() {
        if (this._valueSet == null) {
            this._valueSet = BusinessKeySet.newSet(this);
        }
        return this._valueSet;
    }

    @Override
    public Iterator<V> iterator() {
        return this.values().iterator();
    }
}

