/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.thirdparty.org.apache.wicket.util.time;

import at.molindo.thirdparty.org.apache.wicket.util.time.AbstractTimeValue;
import at.molindo.thirdparty.org.apache.wicket.util.time.Time;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class Duration
extends AbstractTimeValue {
    private static final long serialVersionUID = 1L;
    public static final Duration MAXIMUM = Duration.milliseconds(Long.MAX_VALUE);
    public static final Duration NONE = Duration.milliseconds(0L);
    public static final Duration ONE_DAY = Duration.days(1);
    public static final Duration ONE_HOUR = Duration.hours(1);
    public static final Duration ONE_MINUTE = Duration.minutes(1);
    public static final Duration ONE_SECOND = Duration.seconds(1);
    public static final Duration ONE_WEEK = Duration.days(7);

    public static Duration benchmark(Runnable code) {
        Time start = Time.now();
        code.run();
        return Time.now().subtract(start);
    }

    public static Duration days(double days) {
        return Duration.hours(24.0 * days);
    }

    public static Duration days(int days) {
        return Duration.hours(24 * days);
    }

    public static Duration elapsed(Time start) {
        return start.elapsedSince();
    }

    public static Duration hours(double hours) {
        return Duration.minutes(60.0 * hours);
    }

    public static Duration hours(int hours) {
        return Duration.minutes(60 * hours);
    }

    public static Duration milliseconds(double milliseconds) {
        return Duration.milliseconds(Math.round(milliseconds));
    }

    public static Duration milliseconds(long milliseconds) {
        return new Duration(milliseconds);
    }

    public static Duration minutes(double minutes) {
        return Duration.seconds(60.0 * minutes);
    }

    public static Duration minutes(int minutes) {
        return Duration.seconds(60 * minutes);
    }

    public static Duration seconds(double seconds) {
        return Duration.milliseconds(seconds * 1000.0);
    }

    public static Duration seconds(int seconds) {
        return Duration.milliseconds((long)seconds * 1000L);
    }

    public static Duration valueOf(long time) {
        return new Duration(time);
    }

    protected Duration(long milliseconds) {
        super(milliseconds);
    }

    public Duration add(Duration duration) {
        return Duration.valueOf(this.getMilliseconds() + duration.getMilliseconds());
    }

    public final double days() {
        return this.hours() / 24.0;
    }

    public final double hours() {
        return this.minutes() / 60.0;
    }

    public final double minutes() {
        return this.seconds() / 60.0;
    }

    public final double seconds() {
        return (double)this.getMilliseconds() / 1000.0;
    }

    public final void sleep() {
        if (this.getMilliseconds() > 0L) {
            try {
                Thread.sleep(this.getMilliseconds());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public Duration subtract(Duration that) {
        return Duration.valueOf(this.getMilliseconds() - that.getMilliseconds());
    }

    public void wait(Object object) {
        try {
            object.wait(this.getMilliseconds());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        return this.toString(Locale.getDefault());
    }

    public String toString(Locale locale) {
        if (this.getMilliseconds() >= 0L) {
            if (this.days() >= 1.0) {
                return this.unitString(this.days(), "day", locale);
            }
            if (this.hours() >= 1.0) {
                return this.unitString(this.hours(), "hour", locale);
            }
            if (this.minutes() >= 1.0) {
                return this.unitString(this.minutes(), "minute", locale);
            }
            if (this.seconds() >= 1.0) {
                return this.unitString(this.seconds(), "second", locale);
            }
            return this.getMilliseconds() + " milliseconds";
        }
        return "N/A";
    }

    private String unitString(double value, String units, Locale locale) {
        return Duration.valueOf(value, locale) + " " + units + (value > 1.0 ? "s" : "");
    }

    private static String valueOf(double value, Locale locale) {
        return Duration.valueOf(value, 1, locale);
    }

    private static String valueOf(double value, int places, Locale locale) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return "N/A";
        }
        DecimalFormat format = new DecimalFormat("#." + Duration.repeat(places, '#'), new DecimalFormatSymbols(locale));
        return format.format(value);
    }

    private static String repeat(int times, char c) {
        StringBuilder buffer = new StringBuilder(times);
        for (int i = 0; i < times; ++i) {
            buffer.append(c);
        }
        return buffer.toString();
    }
}

