/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.tools;

import at.molindo.thirdparty.org.apache.http.client.utils.URIUtils;
import at.molindo.utils.collections.MapBuilder;
import at.molindo.utils.data.StringUtils;
import at.molindo.utils.tools.URLCoder;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class UrlBuilder
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String FTP = "ftp";
    private static final Map<String, Integer> PORTS = MapBuilder.builder(new HashMap()).put("http", 80).put("http", 443).put("ftp", 21).getUnmodifiable();
    private static final String[] EMPTY_STRINGS = new String[0];
    private static Pattern PROTOCOL = Pattern.compile("^[^:/?#]+$");
    private static Pattern HOST = Pattern.compile("^[^:@/?#]*$");
    private static Pattern PATH = Pattern.compile("^[^?#]*$");
    private static Pattern QUERY = Pattern.compile("[^#]*");
    private String _protocol;
    private String _user;
    private String _password;
    private String _host;
    private Integer _port;
    private String _path;
    private LinkedHashMap<String, List<String>> _params;
    private String _fragment;
    private Map<String, Integer> _defaultPorts;

    public static UrlBuilder parse(String url) throws MalformedURLException {
        return new UrlBuilder(new URL(url));
    }

    public static LinkedHashMap<String, List<String>> parseQuery(String query) {
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        if (StringUtils.empty(query)) {
            return params;
        }
        query = StringUtils.stripLeading(query.trim(), "?");
        for (String param : query.split("&")) {
            String[] pair = param.split("=", 2);
            String key = UrlBuilder.decode(URLCoder.QUERY, pair[0]);
            String value = UrlBuilder.decode(URLCoder.QUERY, pair.length > 2 ? null : pair[1]);
            List<String> values = params.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                params.put(key, values);
            }
            values.add(value);
        }
        return params;
    }

    public static String encode(URLCoder encoder, String s) {
        if (StringUtils.empty(s)) {
            return null;
        }
        return encoder.encode(s);
    }

    public static List<String> encodeAll(URLCoder encoder, List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> encoded = new ArrayList<String>(list.size());
        for (String s : list) {
            encoded.add(UrlBuilder.encode(encoder, s));
        }
        return encoded;
    }

    public static String decode(URLCoder decoder, String s) {
        if (StringUtils.empty(s)) {
            return null;
        }
        return decoder.decode(s);
    }

    public static List<String> decodeAll(URLCoder decoder, List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> decoded = new ArrayList<String>(list.size());
        for (String s : list) {
            decoded.add(UrlBuilder.decode(decoder, s));
        }
        return decoded;
    }

    public UrlBuilder() {
        this("example.com");
    }

    public UrlBuilder(String host) {
        this(HTTP, host);
    }

    public UrlBuilder(String protocol, String host) {
        this(protocol, host, "/");
    }

    public UrlBuilder(String protocol, String host, String path) {
        this.setProtocol(protocol).setHost(host).setPath(path);
    }

    public UrlBuilder(URL url) {
        this.setUrl(url);
    }

    protected UrlBuilder setUrl(URL url) {
        this.setProtocol(url.getProtocol());
        String userInfo = url.getUserInfo();
        String[] credentials = StringUtils.empty(userInfo) ? EMPTY_STRINGS : userInfo.split(":", 2);
        this.setUser(credentials.length > 0 ? credentials[0] : null);
        this.setPassword(credentials.length > 1 ? credentials[1] : null);
        this.setHost(url.getHost());
        int port = url.getPort();
        this.setPort(port == -1 ? null : Integer.valueOf(port));
        String path = url.getPath();
        this.setPath(StringUtils.empty(path) ? "/" : path);
        this.setQuery(url.getQuery());
        this.setFragment(url.getRef());
        return this;
    }

    public UrlBuilder setProtocol(String protocol) {
        if (StringUtils.empty(protocol)) {
            throw new IllegalArgumentException("protocol must not be empty");
        }
        if (!PROTOCOL.matcher(protocol = protocol.trim()).matches()) {
            throw new IllegalArgumentException("protocol not allowed: " + protocol);
        }
        this._protocol = protocol;
        return this;
    }

    public UrlBuilder setUser(String user) {
        if (!StringUtils.empty(user) && !HOST.matcher(user).matches()) {
            throw new IllegalArgumentException("user not allowed: " + user);
        }
        this._user = UrlBuilder.encode(URLCoder.USER_INFO, user);
        return this;
    }

    public UrlBuilder setPassword(String password) {
        if (!StringUtils.empty(password) && !HOST.matcher(password).matches()) {
            throw new IllegalArgumentException("password not allowed: " + password);
        }
        this._password = UrlBuilder.encode(URLCoder.USER_INFO, password);
        return this;
    }

    public UrlBuilder setHost(String host) {
        if (!StringUtils.empty(host) && !HOST.matcher(host).matches()) {
            throw new IllegalArgumentException("host not allowed: " + host);
        }
        this._host = host;
        return this;
    }

    public UrlBuilder setPort(Integer port) {
        if (port != null && (port < 0 || port > 65535)) {
            throw new IllegalArgumentException("port out of range: " + port);
        }
        this._port = port;
        return this;
    }

    public UrlBuilder setPath(String path) {
        if (StringUtils.empty(path)) {
            throw new IllegalArgumentException("path must not be empty");
        }
        if (!(path = path.trim()).startsWith("/")) {
            throw new IllegalArgumentException("path must start with '/': " + path);
        }
        if (!PATH.matcher(path).matches()) {
            throw new IllegalArgumentException("path not allowed: " + path);
        }
        this._path = path;
        return this;
    }

    public UrlBuilder setQuery(String query) {
        if (!StringUtils.empty(query)) {
            if (!QUERY.matcher(query).matches()) {
                throw new IllegalArgumentException("query not allowed: " + query);
            }
            this.setParams(UrlBuilder.parseQuery(query));
        } else {
            this.clearParams();
        }
        return this;
    }

    public UrlBuilder setParams(LinkedHashMap<String, List<String>> params) {
        this.clearParams();
        this.addParams(params);
        return this;
    }

    public UrlBuilder addParams(LinkedHashMap<String, List<String>> params) {
        for (Map.Entry<String, List<String>> e : params.entrySet()) {
            this.addParams(e.getKey(), e.getValue());
        }
        return this;
    }

    public UrlBuilder setParam(String key, String value) {
        this.setParams(key, value);
        return this;
    }

    public UrlBuilder setParams(String key, String ... values) {
        this.setParams(key, Arrays.asList(values));
        return this;
    }

    public UrlBuilder setParams(String key, List<String> values) {
        key = this.normalizeKey(key);
        LinkedHashMap<String, List<String>> params = this.params();
        if (values == null || values.size() == 0) {
            params.remove(key);
        } else {
            params.put(key, UrlBuilder.encodeAll(URLCoder.QUERY_PARAM, values));
        }
        return this;
    }

    public UrlBuilder addParam(String key, String value) {
        this.addParams(key, value);
        return this;
    }

    public UrlBuilder addParams(String key, String ... values) {
        this.addParams(key, Arrays.asList(values));
        return this;
    }

    public UrlBuilder addParams(String key, List<String> values) {
        key = this.normalizeKey(key);
        LinkedHashMap<String, List<String>> params = this.params();
        List<String> current = params.get(key);
        if (current == null) {
            params.put(key, UrlBuilder.encodeAll(URLCoder.QUERY_PARAM, values));
        } else {
            current.addAll(UrlBuilder.encodeAll(URLCoder.QUERY_PARAM, values));
        }
        return this;
    }

    public UrlBuilder removeParams(String key) {
        if (this._params != null) {
            this._params.remove(this.normalizeKey(key));
        }
        return this;
    }

    public void clearParams() {
        if (this._params != null) {
            this._params.clear();
        }
    }

    private String normalizeKey(String key) {
        if (StringUtils.empty(key)) {
            throw new IllegalArgumentException("key must not be empty");
        }
        return UrlBuilder.encode(URLCoder.QUERY_PARAM, key);
    }

    private LinkedHashMap<String, List<String>> params() {
        if (this._params == null) {
            this._params = new LinkedHashMap();
        }
        return this._params;
    }

    public UrlBuilder setFragment(String fragment) {
        this._fragment = fragment;
        return this;
    }

    public UrlBuilder resolve(String relativePath) {
        try {
            return this.setUrl(URIUtils.resolve(this.toURL().toURI(), relativePath).toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("failed to resolve URL", e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("failed to resolve URL", e);
        }
    }

    public String toUrlString() {
        return this.toUrlString(false);
    }

    public String toUrlString(boolean sortParams) {
        Integer defaultPort;
        StringBuilder buf = new StringBuilder();
        buf.append(this._protocol).append("://");
        if (!StringUtils.empty(this._user)) {
            buf.append(this._user);
            if (!StringUtils.empty(this._password)) {
                buf.append(":").append(this._password);
            }
            buf.append("@");
        }
        buf.append(this._host);
        if (this._port != null && (defaultPort = (this._defaultPorts != null ? this._defaultPorts : PORTS).get(this._protocol)) != null && defaultPort.equals(this._port)) {
            buf.append(":").append(this._port);
        }
        buf.append(this._path);
        if (this._params != null && !this._params.isEmpty()) {
            buf.append("?");
            AbstractMap params = this._params;
            if (sortParams) {
                params = new TreeMap<String, List<String>>(params);
            }
            for (Map.Entry e : params.entrySet()) {
                for (String value : (List)e.getValue()) {
                    buf.append((String)e.getKey()).append("=");
                    if (!StringUtils.empty(value)) {
                        buf.append(value);
                    }
                    buf.append("&");
                }
            }
            buf.setLength(buf.length() - 1);
        }
        if (!StringUtils.empty(this._fragment)) {
            buf.append("#").append(this._fragment);
        }
        return buf.toString();
    }

    public URL toURL() {
        String url = this.toUrlString();
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("builder created malformed URL: " + url);
        }
    }

    public String toString() {
        return this.toUrlString();
    }

    public UrlBuilder clone() {
        try {
            UrlBuilder clone = (UrlBuilder)super.clone();
            if (clone._params != null) {
                clone._params = new LinkedHashMap<String, List<String>>(clone._params);
            }
            if (clone._defaultPorts != null) {
                clone._defaultPorts = new LinkedHashMap<String, Integer>(clone._defaultPorts);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("failed to clone UrlBuilder", e);
        }
    }
}

