/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.io;

import at.molindo.thirdparty.org.apache.tools.bzip2.CBZip2InputStream;
import at.molindo.thirdparty.org.apache.tools.bzip2.CBZip2OutputStream;
import at.molindo.utils.collections.ArrayUtils;
import at.molindo.utils.io.CharsetUtils;
import at.molindo.utils.io.Compression;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamUtils {
    private static final int DEFAULT_BUFFER = 4096;
    private static Logger log = LoggerFactory.getLogger(StreamUtils.class);

    private StreamUtils() {
    }

    public static String string(InputStream in) throws IOException {
        return StreamUtils.string(in, CharsetUtils.UTF_8);
    }

    public static String string(InputStream in, Charset charset) throws IOException {
        return StreamUtils.string(in, charset, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String string(InputStream in, Charset charset, int bufferSize) throws IOException {
        try {
            int n;
            InputStreamReader reader = new InputStreamReader(in, charset);
            StringWriter writer = new StringWriter();
            char[] buffer = new char[bufferSize];
            while ((n = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, n);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            StreamUtils.close((Closeable)in);
        }
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        return StreamUtils.copy(in, out, 4096);
    }

    public static int copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int byteCount;
        byte[] buffer = new byte[bufferSize];
        int bytesCopied = 0;
        while ((byteCount = in.read(buffer, 0, buffer.length)) > 0) {
            out.write(buffer, 0, byteCount);
            bytesCopied += byteCount;
        }
        return bytesCopied;
    }

    public static InputStream decompress(InputStream in, Compression compression) throws IOException {
        switch (compression) {
            case BZIP2: {
                return StreamUtils.newBz2InputStream(in);
            }
            case GZIP: {
                return new GZIPInputStream(in);
            }
            case NONE: {
                return in;
            }
            case AUTO: {
                throw new IllegalArgumentException("can't guess compression from InputStream");
            }
        }
        throw new IllegalArgumentException("compression not implemented: " + (Object)((Object)compression));
    }

    public static OutputStream compress(OutputStream out, Compression compression) throws IOException {
        switch (compression) {
            case BZIP2: {
                return StreamUtils.newBz2OutputStream(out);
            }
            case GZIP: {
                return new GZIPOutputStream(out);
            }
            case NONE: {
                return out;
            }
            case AUTO: {
                throw new IllegalArgumentException("can't guess compression from InputStream");
            }
        }
        throw new IllegalArgumentException("compression not implemented: " + (Object)((Object)compression));
    }

    public static void close(Closeable ... in) {
        StreamUtils.close(Arrays.asList(in));
    }

    public static void close(Iterable<Closeable> iterable) {
        for (Closeable in : iterable) {
            StreamUtils.close(in);
        }
    }

    public static void close(Closeable in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                log.debug("stream close failed", (Throwable)e);
            }
        }
    }

    public static byte[] bytes(InputStream in) throws IOException {
        return StreamUtils.bytes(in, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] bytes(InputStream in, int bufferSize) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(bufferSize);
        try {
            StreamUtils.copy(in, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            StreamUtils.close((Closeable)out);
        }
    }

    public static void readFully(InputStream in, byte[] b) throws EOFException, IOException {
        StreamUtils.readFully(in, b, 0, b.length);
    }

    public static void readFully(InputStream in, byte[] b, int off, int len) throws EOFException, IOException {
        while (len > 0) {
            int read = in.read(b, off, len);
            if (read == -1) {
                throw new EOFException();
            }
            off += read;
            len -= read;
        }
    }

    public static boolean equals(InputStream i1, InputStream i2) throws IOException {
        return StreamUtils.equals(i1, i2, 4096);
    }

    /*
     * Loose catch block
     */
    public static boolean equals(InputStream i1, InputStream i2, int buf) throws IOException {
        boolean bl;
        int length;
        byte[] b2;
        byte[] b1;
        while (true) {
            b1 = new byte[buf];
            b2 = new byte[buf];
            length = i1.read(b1);
            if (length != -1) break block8;
            bl = i2.read(b2, 0, 1) == -1;
            break;
        }
        catch (Throwable throwable) {
            StreamUtils.close(i1, i2);
            throw throwable;
        }
        {
            block9: {
                block8: {
                    StreamUtils.close(i1, i2);
                    return bl;
                }
                try {
                    StreamUtils.readFully(i2, b2, 0, length);
                }
                catch (EOFException e) {
                    boolean bl2 = false;
                    StreamUtils.close(i1, i2);
                    return bl2;
                }
                if (ArrayUtils.equals(b1, b2, 0, length)) break block9;
                boolean bl3 = false;
                StreamUtils.close(i1, i2);
                return bl3;
            }
            continue;
        }
    }

    private static InputStream newBz2InputStream(InputStream in) throws IOException {
        if (in.available() > 2) {
            in.mark(2);
            if (in.read() != 66 || in.read() != 90) {
                in.reset();
            }
        }
        in = new CBZip2InputStream(new BufferedInputStream(in));
        return in;
    }

    private static OutputStream newBz2OutputStream(OutputStream out) throws IOException {
        return new CBZip2OutputStream(new BufferedOutputStream(out));
    }
}

